<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * PreDeliricScores Controller
 *
 * @property \App\Model\Table\PreDeliricScoresTable $PreDeliricScores
 */
class PreDeliricScoresController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selectedted-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'SofaEscores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $preDeliricScores = $this->paginate($this->PreDeliricScores);

        $this->set(compact('preDeliricScores'));
        $this->set('_serialize', ['preDeliricScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Pre Deliric Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $preDeliricScore = $this->PreDeliricScores->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('preDeliricScore', $preDeliricScore);
        $this->set('_serialize', ['preDeliricScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session        = $this->request->session();
        $patients_table = TableRegistry::get('Patients');
        $pacient_id     = $session->read('selected-pacient');
        $patient        = $patients_table->get($pacient_id);

        $preDeliricScore = $this->PreDeliricScores->newEntity();
        if ($this->request->is('post')) {
            $preDeliricScore = $this->PreDeliricScores->patchEntity($preDeliricScore, $this->request->data);
            if ($this->PreDeliricScores->save($preDeliricScore)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->PreDeliricScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('preDeliricScore', 'hospitalizations', 'patient'));
        $this->set('_serialize', ['preDeliricScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Pre Deliric Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {

        $session        = $this->request->session();
        $patients_table = TableRegistry::get('Patients');
        $pacient_id     = $session->read('selected-pacient');
        $patient        = $patients_table->get($pacient_id);

        $preDeliricScore = $this->PreDeliricScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $preDeliricScore = $this->PreDeliricScores->patchEntity($preDeliricScore, $this->request->data);
            if ($this->PreDeliricScores->save($preDeliricScore)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->PreDeliricScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('preDeliricScore', 'hospitalizations', 'patient'));
        $this->set('_serialize', ['preDeliricScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Pre Deliric Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $preDeliricScore = $this->PreDeliricScores->get($id);
        if ($this->PreDeliricScores->delete($preDeliricScore)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não foi deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
    }
}
