<?php
namespace App\Model\Table;

use App\Model\Entity\AreasOfOccupation;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AreasOfOccupation Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $ProfessionalsSpecialties
 */
class AreasOfOccupationTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('areas_of_occupation');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsToMany('ProfessionalsSpecialties', [
            'foreignKey' => 'areas_of_occupation_id',
            'targetForeignKey' => 'professionals_specialty_id',
            'joinTable' => 'areas_of_occupation_professionals'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
