<?php
namespace App\Model\Table;

use App\Model\Entity\SnapIiScore;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SnapIiScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SnapIiScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('snap_ii_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('pressao_arterial_media_mmhg');

        $validator
            ->allowEmpty('temperatura');

        $validator
            ->allowEmpty('pao_fio');

        $validator
            ->allowEmpty('ph');

        $validator
            ->allowEmpty('convulsoes_multiplas');

        $validator
            ->allowEmpty('diurese');

        $validator
            ->integer('pontuacao')
            ->allowEmpty('pontuacao');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->requirePresence('data_realizacao', 'create')
            ->notEmpty('data_realizacao');

         $validator
            ->boolean('pequeno_para_idade_gestacional')
            ->allowEmpty('pequeno_para_idade_gestacional');

         $validator
            ->boolean('apgar')
            ->allowEmpty('apgar');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
