<?php
namespace App\Model\Table;

use App\Model\Entity\SystemicDiagnosi;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SystemicDiagnosis Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Hospitalizations
 */
class SystemicDiagnosisTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('systemic_diagnosis');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsToMany('Hospitalizations', [
            'foreignKey' => 'systemic_diagnosi_id',
            'targetForeignKey' => 'hospitalization_id',
            'joinTable' => 'hospitalizations_systemic_diagnosis'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        return $validator;
    }
}
