<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * DailyItuPreventionBundles Controller
 *
 * @property \App\Model\Table\DailyItuPreventionBundlesTable $DailyItuPreventionBundles
 */
class DailyItuPreventionBundlesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Bundle Diário - ITU');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $bundle_id = $session->read('bundle_id');
        $this->set('bundle_id', $bundle_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

        $screening_id = $session->read('screening_id');
        $this->set('screening_id', $screening_id);

    }

    public function isAuthorized($user)
    {

        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'DailyBundles', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($bundle_id)
    {
        $session = $this->request->session();
        $session->write('bundle_id', $bundle_id);

        $this->paginate = [
            'contain' => ['ItuPreventionBundles'],
            'order'   => ['DailyItuPreventionBundles.created' => 'DESC'],
        ];
        $dailyItuPreventionBundles = $this->paginate($this->DailyItuPreventionBundles);

        $this->set(compact('dailyItuPreventionBundles', 'bundle_id'));
        $this->set('_serialize', ['dailyItuPreventionBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Daily Itu Prevention Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->get($id, [
            'contain' => ['ItuPreventionBundles'],
        ]);

        $this->set('dailyItuPreventionBundle', $dailyItuPreventionBundle);
        $this->set('_serialize', ['dailyItuPreventionBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {

        $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->newEntity();
        if ($this->request->is('post')) {
            $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->patchEntity($dailyItuPreventionBundle, $this->request->data);
            if ($this->DailyItuPreventionBundles->save($dailyItuPreventionBundle)) {

                $bundle_id = $dailyItuPreventionBundle->itu_prevention_bundle_id;

                $this->Flash->success(__('The daily itu prevention bundle has been saved.'));
                return $this->redirect(['action' => 'index', $bundle_id]);
            } else {
                $this->Flash->error(__('The daily itu prevention bundle could not be saved. Please, try again.'));
            }
        }
        $ituPreventionBundles = $this->DailyItuPreventionBundles->ItuPreventionBundles->find('list', ['limit' => 200]);
        $this->set(compact('dailyItuPreventionBundle', 'ituPreventionBundles'));
        $this->set('_serialize', ['dailyItuPreventionBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Daily Itu Prevention Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->patchEntity($dailyItuPreventionBundle, $this->request->data);
            if ($this->DailyItuPreventionBundles->save($dailyItuPreventionBundle)) {
                $this->Flash->success(__('The daily itu prevention bundle has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The daily itu prevention bundle could not be saved. Please, try again.'));
            }
        }
        $ituPreventionBundles = $this->DailyItuPreventionBundles->ItuPreventionBundles->find('list', ['limit' => 200]);
        $this->set(compact('dailyItuPreventionBundle', 'ituPreventionBundles'));
        $this->set('_serialize', ['dailyItuPreventionBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Daily Itu Prevention Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $dailyItuPreventionBundle = $this->DailyItuPreventionBundles->get($id);
        if ($this->DailyItuPreventionBundles->delete($dailyItuPreventionBundle)) {
            $this->Flash->success(__('The daily itu prevention bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The daily itu prevention bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
