<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * NeonatalChecklists Controller
 *
 * @property \App\Model\Table\NeonatalChecklistsTable $NeonatalChecklists
 */
class NeonatalChecklistsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Checklist Neonatal');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CardiacSurgeryChecklists', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $neonatalChecklists = $this->paginate($this->NeonatalChecklists);

        $this->set(compact('neonatalChecklists'));
        $this->set('_serialize', ['neonatalChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Neonatal Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $neonatalChecklist = $this->NeonatalChecklists->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('neonatalChecklist', $neonatalChecklist);
        $this->set('_serialize', ['neonatalChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $neonatalChecklist = $this->NeonatalChecklists->newEntity();
        if ($this->request->is('post')) {
            $neonatalChecklist = $this->NeonatalChecklists->patchEntity($neonatalChecklist, $this->request->data);
            if ($this->NeonatalChecklists->save($neonatalChecklist)) {
                $this->Flash->success(__('The neonatal checklist has been saved.'));
                return $this->redirect(['controller' => 'SurgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The neonatal checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->NeonatalChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('neonatalChecklist', 'hospitalizations'));
        $this->set('_serialize', ['neonatalChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Neonatal Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $neonatalChecklist = $this->NeonatalChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $neonatalChecklist = $this->NeonatalChecklists->patchEntity($neonatalChecklist, $this->request->data);
            if ($this->NeonatalChecklists->save($neonatalChecklist)) {
                $this->Flash->success(__('The neonatal checklist has been saved.'));
                return $this->redirect(['controller' => 'SurgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The neonatal checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->NeonatalChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('neonatalChecklist', 'hospitalizations'));
        $this->set('_serialize', ['neonatalChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Neonatal Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $neonatalChecklist = $this->NeonatalChecklists->get($id);
        if ($this->NeonatalChecklists->delete($neonatalChecklist)) {
            $this->Flash->success(__('The neonatal checklist has been deleted.'));
        } else {
            $this->Flash->error(__('The neonatal checklist could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function printView($id = null)
    {
        $is_print_view = true;
        
        $units_table = TableRegistry::get('Units');

        $session    = $this->request->session();

        $unit_id    = $session->read('selected-unit');

        $unit = $units_table->get($unit_id);



        $neonatalChecklist = $this->NeonatalChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $neonatalChecklist = $this->NeonatalChecklists->patchEntity($neonatalChecklist, $this->request->data);
            if ($this->NeonatalChecklists->save($neonatalChecklist)) {
                $this->Flash->success(__('The neonatal checklist has been saved.'));
                return $this->redirect(['controller' => 'SurgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The neonatal checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->NeonatalChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('is_print_view','unit','neonatalChecklist', 'hospitalizations'));
        $this->set('_serialize', ['neonatalChecklist']);
    }
}
