<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * Units Controller
 *
 * @property \App\Model\Table\UnitsTable $Units
 */
class UnitsController extends AppController
{

    public function beforeFilter(\Cake\Event\Event $event)
    {
        parent::beforeFilter($event);

//$this->Auth->allow(['add', 'logout','index']);
        //$this->Auth->allow( ['attachUsers', 'listUsers', 'linkUserToUnit', 'unlinkUserFromUnit'] );
    }

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Unidade');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'units', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $session = $this->request->session();
        $user_id = $session->read('Auth.User.id');
        $user_role = $session->read('Auth.User.role_id');

        $users = TableRegistry::get('Users');

        $query = $this->Units->find();
        $query->innerJoinWith('Users', function ($q)
        {
            return $q->where(['Users.id' => $user_id]);
        });

        $this->paginate = [
            'contain' => ['Groups', 'Users'],
            //'conditions' => ['Users.id = ' =>  $user_id]
        ];

        $units = $this->paginate($this->Units);
        //$units = $this->paginate($query);

        $this->set(compact('units', 'user_role'));
        $this->set('_serialize', ['units']);
    }

    /**       * View method       *       * @param string|null $id Unit id.
     * @return \Cake\Network\Response|null       * @throws
    \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $unit = $this->Units->get($id, [
            //'contain' => ['Groups', 'Goals','HealthInsurancePlans', 'Hospitalizations', 'Origins', 'Signs'],
            'contain' => ['Groups', 'Signs'],
        ]);

        $this->set('unit', $unit);
        $this->set('_serialize', ['unit']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $unit = $this->Units->newEntity();
        $units_users_table = TableRegistry::get('UnitsUsers');
        $signs_table = TableRegistry::get('Signs');
        //$sign              = $signs_table->newEntity();

        $session = $this->request->session();
        $user_id = $session->read('Auth.User.id');

// $groups = TableRegistry::get('Groups');

// $result = $groups->find();

// $results = $result->toArray();

// $this->set('groups', $results);

        if ($this->request->is('post'))
        {
            $unit = $this->Units->patchEntity($unit, $this->request->data);

//$unit->filename = 'Logo-GH.png';
            if ($this->Upload->sendMultiple($this->request->data, $unit))
            {
                $this->Flash->success(__('A Unidade foi salva com sucesso.'));
                $this->Units->addDefaultSigns($unit->id);
                return $this->redirect(['action' => 'index']);
            }

// if ($this->Units->save($unit)) {

//     //add the defaults sinalizations

//     $this->Units->addDefaultSigns($unit->id);

//     $this->Flash->success(__('A unidade foi salva.'));

//     return $this->redirect(['action' => 'index']);
            // }
            else
            {
                $this->Flash->error(__('A unidade não pode ser salva. Por favor, tente novamente.'));
            }
        }

        $groups = $this->Units->Groups->find('list', ['limit' => 200]);

        $this->set(compact('unit', 'groups'));
        $this->set('_serialize', ['unit']);
    }

/**
 * Edit method
 *
 * @param string|null $id Unit id.
 * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
 * @throws \Cake\Network\Exception\NotFoundException When record not found.
 */
    public function edit($id = null)
    {
        $session = $this->request->session();
        $role_name = $session->read('Auth.User.role_name');
        $unit = $this->Units->get($id);

        if ($this->request->is(['patch', 'post', 'put']))
        {
            $unit = $this->Units->patchEntity($unit, $this->request->data);

            if ($this->Upload->sendMultiple($this->request->data, $unit))
            {
                //if ($this->Units->save($unit)) {
                {

                    if (isset($unit->filename))
                    {
                        $this->request->session()->write('unit_logo', $unit->filename);
                    }

                    $this->Flash->success(__('A Unidade foi salva com sucesso.'));
                }

                if ($role_name == "Administrador")
                {
                    return $this->redirect(['action' => 'index']);
                }
                else
                {
                    return $this->redirect(['controllers'=>'sectors', 'action' => 'index']);
                }
            }
            else
            {
                $this->Flash->error(__('A Unidade não pode ser salva. Por favor, tente novamente.'));
            }
        }

        $groups = $this->Units->Groups->find('list', ['limit' => 200]);
        //$goals = $this->Units->Goals->find('list', ['limit' => 200]);
        $this->set(compact('unit', 'groups'));
        $this->set('_serialize', ['unit']);
    }

/**
 * Delete method
 *
 * @param string|null $id Unit id.
 * @return \Cake\Network\Response|null Redirects to index.
 * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
 */
//delta a unidade
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $unit = $this->Units->get($id);

        $unit['is_active'] = false;

        if ($this->Units->save($unit))
        {
            $this->Flash->success(__('A Unidade foi suspensa com sucesso.'));
        }
        else
        {
            $this->Flash->error(__('A Unidade não pode ser suspensa. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

//suspende a unidade
    public function desactivate($id = null)
    {
        $this->request->allowMethod(['post', 'desactivate']);
        $unit = $this->Units->get($id);

        $unit['is_active'] = false;

        if ($this->Units->save($unit))
        {
            $this->Flash->success(__('A Unidade foi suspensa com sucesso.'));
        }
        else
        {
            $this->Flash->error(__('A Unidade não pode ser suspensa. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

//ativa a unidade
    public function activate($id = null)
    {
        $this->request->allowMethod(['post', 'activate']);
        $unit = $this->Units->get($id);
        $unit->is_active = true;

        if ($this->Units->save($unit))
        {
            $this->Flash->success(__('A Unidade foi ativada com sucesso.'));
        }
        else
        {
            $this->Flash->error(__('A Unidade não pode ser ativada. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

//seleciona uma unidade e grava o id na session
    public function select($id = null)
    {
        $this->render(false);

        //logged user id
        $user_id = $this->request->session()->read('Auth.User.id');
        $this->request->session()->write('unit_logo', null);

        //get user privilege
        $UnitsUsers_table = TableRegistry::get('UnitsUsers');
        $UnitsUsers = $UnitsUsers_table
            ->find()
            ->contain(['Privileges'])
            ->where(['UnitsUsers.unit_id =' => $id, 'UnitsUsers.user_id =' => $user_id])
            ->first();

        $unit = $this->Units
            ->find()
            ->contain(['Groups'])
            ->where(['Units.id =' => $id])
            ->first()
        ;

        // echo "<pre>";

        // echo "shiit";

        // print_r($UnitsUsers);

        // exit;

        //return;

        // Log::write('debug', '$UnitsUsers');

        //    Log::write('debug', $UnitsUsers );

        //    return;

        if (!$unit['is_active'])
        {
            $this->Flash->warning(__('Esta unidade está suspensa.'));
            return $this->redirect($this->referer());
        }

        if (!$UnitsUsers)
        {
            $this->Flash->warning(__('Voce nao foi vinculado a esta unidade.'));
            return $this->redirect($this->referer());
        }

        if (!empty($unit->name))
        {
            //$this->request->session()->write('Config.language', 'eng');
            $this->request->session()->write('selected-unit', $id);
            $this->request->session()->write('selected-unit-name', $unit->name);

            $user_units = $this->request->session()->read('Auth.User');
            $user_units = $user_units['units'];

            $this->request->session()->write('selected-unit-role-name', $UnitsUsers->privilege->name);
            $this->request->session()->write('selected-unit-privilege', $UnitsUsers->privilege->name);

            //pega a logo do grupo de unidade

            // if (isset($unit->group->filename)) {

            //     $this->request->session()->write('unit_logo', $unit->group->filename);

            // }

            if (isset($unit->filename))
            {
                $this->request->session()->write('unit_logo', $unit->filename);
            }
            else
            {
                $this->request->session()->write('unit_logo', 'default.png');
            }

            $this->set('unit', $unit);

            //$this->Flash->success(__('A unidade foi selecionada.'));
            return $this->redirect(['controller' => 'Sectors', 'action' => 'index']);
            //return $this->redirect(['controller'=>'Users', 'action' => 'listUsersFromUnit']);
        }
        else
        {
            $this->Flash->success(__('Ocorreu um erro. Por favor, tente novamente.'));
            return $this->redirect(['action' => 'select-unit']);
        }
    }

    public function selectUnit()
    {
        $this->set('title', 'Selecionar Unidade');
        $session = $this->request->session();
        $units = $session->read('Auth.User.units');
        $user_id = $session->read('Auth.User.id');
        $units_id = [];

        $this->paginate = [
            'contain' => ['Users'],
            //'conditions' => ['Users.id = ' => $user_id],
        ];

        foreach ($units as $key => $unit)
        {
            $units_id[$key] = $unit['unit_id'];
        }

        Log::write('debug', 'unit_id');
        Log::write('debug', $units_id);

        // $conn = ConnectionManager::get('default');

        // $stmt = $conn->execute(

        //     'INSERT INTO units_users (user_id, unit_id, privilege_id) values (?, ?, ?)',

        //     [$user_id, $unit_id, 1]

        // );

        // $results = $stmt ->fetchAll('assoc');

        if (!empty($units_id))
        {
            $query = $this->Units->find()

                ->contain(['Groups'])
                ->where(['Units.id IN' => $units_id])

        // ->contain(['Groups', 'Users' => function ($q) {

        //     return $q

        //         ->contain(['Privileges'])

        //         ->where(['Users.id' => ]);

        // }])

        // ->matching('Users', function (\Cake\ORM\Query $q) {

        //     //$q->contain(['UnitsUsers' => ['Privileges']]);

        //     //return $q->distinct(['Privileges.id']);

        //     //->where(['Users.id' => $user_id]);

        //     return $q->where(['Users.id' => "Units.id"]);
                    // })
                ->distinct(['Units.id'])
            ;

            $units = $this->paginate($query);
        }
        else
        {
            //$units = $this->paginate();
        }

        // $this->paginate = [

        // 'contain' => ['Groups'],

        // 'where'=> ['Units.id IN'=>$units_id]
        // ];

        $this->set('default_logo', 1);
        $this->set(compact('units'));
        $this->set('_serialize', ['units']);
    }

    //seleciona o id da unidade para o admin

    /* $this->autoRender = false;

    if ($this->request->is('Ajax')) {
    $session = $this->request->session();

    if (isset($this->request->query['date_before']) && $this->request->query['date_before'] !== "") {
    $date_before = $this->request->query['date_before'];
    $session->write('date_before', $date_before);
    }

    if (isset($this->request->query['date_after']) && $this->request->query['date_after'] !== "") {
    $date_after = $this->request->query['date_after'];
    $session->write('date_after', $date_after);
    }

    $this->response->body
    (
    json_encode(
    [
    "date_before" => $date_before,
    "date_after"  => $date_after,
    ])
    );
    return $this->response;
    }*/
    public function adminSelect($id = null)
    {
        $this->render(false);
        $unit = $this->Units
            ->find()
            ->contain(['Groups'])
            ->where(['Units.id =' => $id])
            ->first()
        ;

        if ($this->request->is('Ajax'))
        {
            $session = $this->request->session();
            $this->request->session()->write('selected-unit', $id);
            $this->request->session()->write('selected-unit-name', $unit->name);
            $this->set('unit_id', $id);
            $this->set('unit', $id);
            $this->response->body
                (
                json_encode(
                    [
                        "unit_id" => $id,
                        "status" => $unit->is_active,
                    ])
            );
            return $this->response;
        }
    }

//lista todos os usuarios do tipo qualidade
    public function listUsers($unit_id = null)
    {
        $action = $this->request->params['action'];
        Log::write('debug', 'action');
        Log::write('debug', $action);

        $session = $this->request->session();
        $user_id = $session->read('Auth.User.id');

        $param = $this->request;
        $filter = null;

// echo "<pre>";

// print_r($unit_id);

// exit;

//$unitId = $param['pass'][0];
        //$unit_id = 1;
        $users = TableRegistry::get('Users');

        $unitsTable = TableRegistry::get('Units');
        $unit_result = $unitsTable->find()
            ->where(['Units.id' => $unit_id]);

        $first_unit = $unit_result->toArray();

        if (isset($param->query['search']))
        {
            $filter = $param->query['search'];

            $query = $users->find()
                ->where(['Users.role_id =' => 2, 'Users.name LIKE ' => $filter . '%'])
                ->contain(['Units'])
            ;
        }
        else
        {
            $query = $users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
            ;

// Log::write('debug', 'filter nao foi');

// Log::write('debug', $param->query['search']);
            // Log::write('debug', $param['search']);
        }

// $query->leftJoinWith('Units', function ($q)

// {

//     return $q->where(['Units.id' => $unit_id ]);
        // });

        $query->innerJoinWith('Units')
            ->where(['Units.id' => $unit_id])
            ->autoFields(true);

//$this->paginate = [

//'contain' => ['Units']

//'conditions' => ['Users.id = ' =>  $user_id]
        //];

        $users = $this->paginate($query);
        //$units = $this->paginate($query);

        $this->set(compact('users', 'unit_id', 'first_unit'));
        $this->set('_serialize', ['users']);
    }

    public function attachUsers($unit_id = null)
    {
        $session = $this->request->session();
        $user_id = $session->read('Auth.User.id');

        $param = $this->request;
        $filter = null;

// echo "<pre>";

// print_r($unit_id);

// exit;

//$unitId = $param['pass'][0];
        //$unit_id = 1;
        $users = TableRegistry::get('Users');

        $unit = $this->Units->get($unit_id);

        if (isset($param->query['search']))
        {
            $filter = $param->query['search'];

            $query = $users->find()
                ->where(['Users.role_id =' => 2, 'Users.name LIKE ' => $filter . '%'])
                ->contain(['Units'])
            // ->order(['Units.id'])
            ;
        }
        else
        {
            $query = $users->find()
                ->where(['Users.role_id =' => 2])
                ->contain(['Units'])
            //->order(['Units.id'])
            ;

// Log::write('debug', 'filter nao foi');

// Log::write('debug', $param->query['search']);
            // Log::write('debug', $param['search']);
        }

// $query->leftJoinWith('Units', function ($q)

// {

//     return $q->where(['Units.id' => $unit_id ]);
        // });

        $query->leftJoinWith('Units')
            ->where(['Units.id' => $unit_id])
            ->autoFields(true);

//$this->paginate = [

//'contain' => ['Units']

//'conditions' => ['Users.id = ' =>  $user_id]
        //];

        $users = $this->paginate($query);
        //$units = $this->paginate($query);

        $unit_name = $unit->name;

        $this->set(compact('users', 'unit_id', 'unit_name'));
        $this->set('_serialize', ['users']);
    }

//vincula um usuário a unidade
    public function linkUserToUnit($unit_id = null, $user_id = null)
    {

        $conn = ConnectionManager::get('default');
        $stmt = $conn->execute(
            'INSERT INTO units_users (user_id, unit_id, privilege_id) values (?, ?, ?)',
            [$user_id, $unit_id, 1]
        );

        $code = $stmt->errorCode();
        $info = $stmt->errorInfo();

        if ($code === '00000')
        {
            $this->Flash->success(__('O usuário foi vinculado com sucesso.'));
        }
        else
        {
            $this->Flash->error(__('O usuário não pode ser vinculado a unidade.'));
        }

        return $this->redirect(['action' => 'attachUsers', $unit_id]);
    }

//desvincula um usuário da unidade
    public function unlinkUserFromUnit($unit_id = null, $user_id = null, $type = null)
    {

//echo "type = " . $type;
        //exit;
        $conn = ConnectionManager::get('default');
        $stmt = $conn->execute(
            'DELETE FROM units_users  WHERE user_id = ? AND unit_id = ?',
            [$user_id, $unit_id]
        );

        $code = $stmt->errorCode();
        $info = $stmt->errorInfo();

        if ($code === '00000')
        {
            $this->Flash->success(__('O usuário foi desvinculado com sucesso.'));
        }
        else
        {
            $this->Flash->error(__('O usuário não pode ser desvinculado a unidade.'));
        }

        if ($type == 'list-users')
        {
            return $this->redirect(['action' => 'listUsers', $unit_id]);
        }
        else
        {
            return $this->redirect(['action' => 'attachUsers', $unit_id]);
        }
    }
}
