<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * MedicationDescription Entity.
 *
 * @property int $id
 * @property string $name
 * @property string $category
 * @property string $channel
 * @property string $frequency
 * @property \Cake\I18n\Time $start_date
 * @property \Cake\I18n\Time $end_date
 * @property bool $is_antibiotic
 * @property string $justificativa_antibiotico
 * @property \Cake\I18n\Time $start_time
 * @property int $using_time
 * @property bool $imediate_start
 * @property string $observation
 * @property string $presentation
 * @property int $quantity
 * @property string $schedule
 * @property bool $is_surveillance_signed
 * @property string $surveillance_signaling
 * @property string $special_conditioning
 * @property bool $is_restricted_by_sectors
 * @property bool $is_restricted_by_users
 * @property bool $accepts_devolution
 * @property bool $controlled_drug
 * @property float $unitary_price
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $modified
 * @property bool $is_active
 * @property \App\Model\Entity\PrescriptionMedication[] $prescription_medications
 * @property \App\Model\Entity\SystemMedication[] $system_medications
 */
class MedicationDescription extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
