<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;
use Cake\ORM\TableRegistry;

/**
 * Room Entity.
 *
 * @property int $id
 * @property string $type
 * @property int $limit_of_patients
 * @property int $sector_id
 * @property \App\Model\Entity\Sector $sector
 */
class Room extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];

    public function screening($patient_id = null, $type = null){

        $queixa_principal       = ['alteracao_estado_mental' => 'Alteração de estado mental', 'dispneia' => 'Dispneia', 'hiperglicemia' => 'Hiperglicemia', 'alt_sinais_vitais' => 'Alt. sinais vitais isolados', 'tosse' => 'Tosse', 'lesoes_de_pele' => 'Lesões de pele', 'dor' => 'Dor', 'febre' => 'Febre', 'hipoglicemia' => 'Hipoglicemia', 'diarreia' => 'Diarreia', 'casos_especiais' => 'Casos especiais', 'procura_da_unidade' => 'Procura da unidade p/ procedimentos', 'hemorragia' => 'Hemorragia', 'alteracao_de_pressao' => 'Alteração de pressão', 'parada_cardiorrespiratoria' => 'Parada cardiorrespiratória', 'hemorragia_digestiva' => 'Hemorragia digestiva', 'queixas_cronicas' => 'Queixas crônicas'];

        $screening_table = TableRegistry::get('Screenings');
        $screenings = $screening_table->find('all', [
            'contain' => ["MedicalCares", "Admissions", 'Patients' => ['Diagnostics'], 'Professionals' => ["Users"]],

            'conditions' => ['Screenings.unit_id' => 1, 'Screenings.patient_id' => $patient_id],
            'order'=>['Screenings.id desc'],
            'limit'=>[1],

        ]);
        $el = '';
        foreach ($screenings as $key => $screening) {
            //echo 'ssss' . $screening["id"];
            if($type == 'classificacaoRisco'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $screening["classificacao_selecionada"] ) && $screening["classificacao_selecionada"] != "" ) {
                    //echo "aaaaaaa";
                    $el = $screening["classificacao_selecionada"];
                } else {
                    //echo "bbbbbbb";
                    $el = $screening["classificacao_sugerida"]; 
                }
            }

            if($type == 'queixa_principal'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $queixa_principal[$screening["queixa_principal"]] ) ) {
                    $el = $queixa_principal[$screening["queixa_principal"]];
                }
            }

            if($type == 'status'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $screening["medical_cares"]["status"] ) ) {
                    $el = $screening["medical_cares"]["status"];
                }
            }

            if($type == 'nome_medico'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $screening["professional"]["user"] ) ) {
                    $el = $screening["professional"]["user"]["name"];
                }
            }

            if($type == 'data_ultimo_atendimento'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                foreach ($screening["medical_cares"] as $key => $medical_care) {
                    $el = $medical_care["created"];
                }
            }

        }

        return $el;        
    }

    public function hospitalization($patient_id = null, $type = null){

        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $hospitalizations = $hospitalization_table->find('all', [
            'contain' => ["IdentificationOfRisks", 'Patients', 'HistoricPatientMovements' => ['Rooms' => ['Sectors']], 'Diagnostics'],

            'conditions' => [
                'Hospitalizations.unit_id' => 1, 'Patients.id' => $patient_id
                /*'Hospitalizations.created >\'' . $date_before . '\' and Hospitalizations.created < \'' . $date_after . '\'',*/

            ],
        ]);
        $el = '';
        foreach ($hospitalizations as $key => $hospitalization) {
            //echo 'ssss' . $screening["id"];
            if($type == 'classificacaoRisco'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset($hospitalization['patient']["nome"] ) ) {
                    $el = $hospitalization['patient']["nome"];
                }
            }

            /*if($type == 'queixa_principal'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $queixa_principal[$screening["queixa_principal"]] ) ) {
                    $el = $queixa_principal[$screening["queixa_principal"]];
                }
            }

            if($type == 'status'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $screening["medical_cares"]["status"] ) ) {
                    $el = $screening["medical_cares"]["status"];
                }
            }

            if($type == 'nome_medico'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                if ( isset( $screening["professional"]["user"] ) ) {
                    $el = $screening["professional"]["user"]["name"];
                }
            }

            if($type == 'data_ultimo_atendimento'){
                //echo 'ssss222' . $screening["classificacao_sugerida"];
                foreach ($screening["medical_cares"] as $key => $medical_care) {
                    $el = $medical_care["created"];
                }
            }*/

        }

        return $el;        
    }

}
 