<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SafeSurgeryBundle Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $created
 * @property bool $is_active
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property bool $tci_cirurgico
 * @property bool $ficha_pre_anestesica
 * @property bool $tci_anestesico
 * @property bool $precaucao
 * @property bool $marcacao_lateralidade
 * @property bool $jejum
 * @property \Cake\I18n\Time $data_inicio_jejum
 * @property \Cake\I18n\Time $hora_inicio_jejum
 * @property bool $estado_de_desnutricao
 * @property bool $realizacao_de_swab
 * @property bool $paciente_colonizado_staphy
 * @property bool $germe_apresenta_resistencia
 * @property bool $banho_com_cleoxidine
 * @property bool $uso_de_mupirocina
 * @property bool $2_pulseira_identificacao
 * @property bool $2_marcacao_lateralidade
 * @property bool $2_tci_cirurgico
 * @property bool $2_ficha_pre_anestesica
 * @property bool $2_tci_anestesico
 * @property bool $2_risco_de_queda
 * @property bool $2_precaucoes
 * @property string $2_precaucoes_tipo
 * @property bool $2_proteses
 * @property bool $2_adorno
 * @property bool $2_roupa_intima
 * @property bool $2_prontuario
 * @property bool $2_prescricao_bh
 * @property bool $2_exame_imagem
 * @property bool $2_exame_laboratorio
 * @property bool $3_pulseira_identificacao
 * @property bool $3_marcacao_lateraliidade
 * @property bool $3_pulseira_vermelha
 * @property bool $3_precaucoes
 * @property string $3_precaucoes_tipo
 * @property bool $3_proteses
 * @property bool $3_tci
 * @property bool $3_roupa_intima
 * @property bool $4_confirmado_nome_paciente
 * @property bool $4_confimado_tipo_procedimento
 * @property bool $4_marcacao_lateralidade
 * @property bool $4_checagem_equipamento
 * @property bool $4_oximetro_em_funcionamento
 * @property bool $4_alergia
 * @property string $4_alergia_tipo
 * @property bool $4_via_aerea_dificil
 * @property bool $4_disponibilizado_equip_vad
 * @property bool $4_risco_pera_sanguinea
 * @property bool $4_acesso_venoso_adequado
 * @property bool $4_reserva_de_sangue
 * @property string $4_total_reserva_de_sangue
 * @property bool $4_manutencao_normotemia
 * @property bool $4_controle_glicemia
 * @property bool $5_confimacao_equipe_nome
 * @property bool $5_confirmado_tipo_procedimento
 * @property bool $5_antibiocoprofilaxia
 * @property string $5_antibiocoprofilaxia_texto
 * @property bool $5_dose_antibiotico_ajuistada
 * @property bool $5_repique
 * @property bool $5_tricotomia_previa
 * @property bool $5_uso_do_bisturi
 * @property string $5_localizacao_da_placa
 * @property string $5_tipo_anestesia
 * @property bool $5_uso_fracao_inspirada
 * @property bool $5_porta_cirurgica_fechada
 * @property bool $6_houve_alteracao_procedimento
 * @property bool $6_houve_mudanca_diagnostico
 * @property bool $2_pulseira_vermelha
 * @property bool $3_nome_correto
 * @property bool $3_ficha_pre
 * @property bool $3_tci_anestesico
 * @property \Cake\I18n\Time $5_antibiocoprofilaxia_hora
 * @property string $precaucoes_tipo
 * @property string $6_houve_mudanca_diagnostico_qual
 * @property bool $6_tempo_cirurgia_adequado
 * @property bool $6_contagem_de_compressas
 * @property bool $6_encaminhamento_introdutor_arterial
 * @property bool $6_presenca_hematoma
 * @property string $6_qual_lateralidade
 * @property bool $6_peca_anatomica_identificada
 * @property bool $6_curativo
 * @property string $6_curativo_localidade
 * @property bool $6_integridade_da_pele
 * @property string $6_integridade_da_pele_local
 * @property bool $7_acesso_periferico
 * @property string $7_acesso_periferico_local
 * @property bool $7_acesso_venoso_central
 * @property string $7_acesso_venoso_central_local
 * @property bool $7_curativo_acesso_periferico
 * @property bool $7_curativo_acesso_venoso_central
 * @property bool $7_acesso_arterial
 * @property string $7_acesso_arterial_local
 * @property bool $7_curativo_acesso_arterial
 * @property bool $7_sonda_nasogastrica
 * @property bool $7_nasogastrica_confirmada_posicao
 * @property bool $7_sonda_nasoenteral
 * @property bool $7_nasoenteral_confirmada_posicao
 * @property bool $7_sonda_vesical_demora
 * @property bool $7_vesical_confirmada_posicao
 * @property bool $7_intubacao_endotraqueal
 * @property string $7_intubacao_tipo
 * @property bool $7_intubacao_confirmado_posicionamento
 * @property bool $7_dreno_torax
 * @property string $7_dreno_torax_local
 * @property bool $7_dreno_torax_confirmado_posicionamento
 * @property bool $7_dreno_mediastino
 * @property bool $7_curativo_dreno_mediastino
 * @property bool $7_cateter_pic
 * @property bool $7_cateter_pic_pressao_zerada
 * @property bool $7_cateter_drenagem_ventricular
 * @property bool $7_sistema_coletor_funcionante
 * @property bool $7_dreno_cavitario
 * @property bool $7_curativo_dreno_cavitario
 * @property bool $7_fio_marcapasso
 * @property bool $7_curativo_fio_marcapasso
 * @property bool $7_colostomia
 * @property bool $7_bolsa_de_colostomia
 * @property bool $7_compressor_pneumatico
 * @property bool $7_mante_termica
 * @property bool $7_curativos_datados
 * @property bool $7_drenos_sondas_datados
 * @property string $7_exames_laboratoriais
 * @property string $7_hemocomponentes
 * @property bool $7_paciente_manutencao
 * @property bool $7_paciente_controle_glicemia
 * @property bool $7_uso_de_fracao
 * @property string $7_drogas_em_curso_1
 * @property string $7_drogas_em_curso_2
 * @property string $7_drogas_em_curso_3
 * @property string $7_drogas_em_curso_4
 * @property string $7_drogas_em_curso_5
 * @property string $7_drogas_em_curso_6
 * @property bool $7_intercorrencias_cirurgica
 * @property string $7_inter_cirurgica_cite
 * @property string $7_inter_cirurgica_motivo
 * @property bool $7_inter_anestesica
 * @property string $7_inter_anestesica_cite
 * @property string $7_inter_anestesica_motivo
 * @property bool $7_pertences_arrumados
 * @property int $room_id
 * @property \App\Model\Entity\Room $room
 * @property string $7_dreno_cavitario_local
 * @property \App\Model\Entity\SafeSurgeryDiaryBundle[] $safe_surgery_diary_bundles
 */
class SafeSurgeryBundle extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
