<?php
namespace App\Model\Table;

use App\Model\Entity\UnitPrescriptionsMetric;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * UnitPrescriptionsMetrics Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Units
 */
class UnitPrescriptionsMetricsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('unit_prescriptions_metrics');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('total_items')
            ->allowEmpty('total_items');

        $validator
            ->integer('total_high_surveillance_items')
            ->allowEmpty('total_high_surveillance_items');

        $validator
            ->integer('total_potentially_dangerous_items')
            ->allowEmpty('total_potentially_dangerous_items');

        $validator
            ->integer('total_active_prescriptions')
            ->allowEmpty('total_active_prescriptions');

        $validator
            ->integer('prescription_with_meds_low_stock')
            ->allowEmpty('prescription_with_meds_low_stock');

        $validator
            ->integer('prescription_with_meds_zero_stock')
            ->allowEmpty('prescription_with_meds_zero_stock');

        $validator
            ->integer('total_validated_prescriptions')
            ->allowEmpty('total_validated_prescriptions');

        $validator
            ->integer('prescription_with_standardized_meds')
            ->allowEmpty('prescription_with_standardized_meds');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
