<?php
namespace App\Model\Table;

use App\Model\Entity\BarthelIndex;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * BarthelIndexes Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Barthels
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class BarthelIndexesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('barthel_indexes');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Barthels', [
            'foreignKey' => 'barthel_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('alimentacao');

        $validator
            ->allowEmpty('banho');

        $validator
            ->allowEmpty('atividades_rotineiras');

        $validator
            ->allowEmpty('vestir_se');

        $validator
            ->allowEmpty('intestino');

        $validator
            ->allowEmpty('sistema_urinario');

        $validator
            ->allowEmpty('uso_do_banheiro');

        $validator
            ->allowEmpty('transferencia');

        $validator
            ->allowEmpty('mobilidade');

        $validator
            ->allowEmpty('escadas');

        $validator
            ->allowEmpty('total_pontos');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('alimentacao_24');

        $validator
            ->allowEmpty('alimentacao_alta');

        $validator
            ->allowEmpty('banho_24');

        $validator
            ->allowEmpty('banho_alta');

        $validator
            ->allowEmpty('atividades_rotineiras_24');

        $validator
            ->allowEmpty('atividades_rotineiras_alta');

        $validator
            ->allowEmpty('vestir_se_24');

        $validator
            ->allowEmpty('vestir_se_alta');

        $validator
            ->allowEmpty('intestino_24');

        $validator
            ->allowEmpty('intestino_alta');

        $validator
            ->allowEmpty('uso_do_banheiro_24');

        $validator
            ->allowEmpty('uso_do_banheiro_alta');

        $validator
            ->allowEmpty('transferencia_24');

        $validator
            ->allowEmpty('transferencia_alta');

        $validator
            ->allowEmpty('mobilidade_24');

        $validator
            ->allowEmpty('mobilidade_alta');

        $validator
            ->allowEmpty('escadas_24');

        $validator
            ->allowEmpty('escadas_alta');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["barthel_indexes"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['barthel_id'], 'Barthels'));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
