<?php
namespace App\Model\Table;

use App\Model\Entity\ChestPainProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ChestPainProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsToMany $Echocardiograms
 */
class ChestPainProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('chest_pain_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id'
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id'
        ]);
        $this->belongsToMany('Echocardiograms', [
            'foreignKey' => 'chest_pain_protocol_id',
            'targetForeignKey' => 'echocardiogram_id',
            'joinTable' => 'chest_pain_protocols_echocardiograms'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->time('hora_zero')
            ->allowEmpty('hora_zero');

        $validator
            ->time('hora_ecg')
            ->allowEmpty('hora_ecg');

        $validator
            ->allowEmpty('suspeita_sca');

        $validator
            ->time('hora_trombolitico')
            ->allowEmpty('hora_trombolitico');

        $validator
            ->time('aas_hora')
            ->allowEmpty('aas_hora');

        $validator
            ->time('clopidogrel_hora')
            ->allowEmpty('clopidogrel_hora');

        $validator
            ->integer('ticagrelor')
            ->allowEmpty('ticagrelor');

        $validator
            ->allowEmpty('tmp_medio_permanencia_uci');

        $validator
            ->allowEmpty('tmp_medio_permanencia_hospitalar');

        $validator
            ->allowEmpty('aas_mg');

        $validator
            ->allowEmpty('has');

        $validator
            ->allowEmpty('disapidemia');

        $validator
            ->allowEmpty('sedentarismo');

        $validator
            ->allowEmpty('estresse');

        $validator
            ->allowEmpty('hf');

        $validator
            ->allowEmpty('tabagismo');

        $validator
            ->allowEmpty('ex_tabagista');

        $validator
            ->allowEmpty('obesidade');

        $validator
            ->allowEmpty('angina');

        $validator
            ->allowEmpty('iam');

        $validator
            ->allowEmpty('cat');

        $validator
            ->allowEmpty('avm_data');

        $validator
            ->allowEmpty('avm_ponte');

        $validator
            ->allowEmpty('icp_vasos');

        $validator
            ->boolean('ulcera')
            ->allowEmpty('ulcera');

        $validator
            ->boolean('cancer')
            ->allowEmpty('cancer');

        $validator
            ->boolean('sangramento')
            ->allowEmpty('sangramento');

        $validator
            ->allowEmpty('sangramento_sitio');

        $validator
            ->boolean('outros')
            ->allowEmpty('outros');

        $validator
            ->allowEmpty('outros_text');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('peso');

        $validator
            ->allowEmpty('altura');

        $validator
            ->time('hora')
            ->allowEmpty('hora');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('sat02');

        $validator
            ->allowEmpty('tamp');

        $validator
            ->allowEmpty('av_de_enfermagem');

        $validator
            ->allowEmpty('anaminese');

        $validator
            ->allowEmpty('hipotese');

        $validator
            ->boolean('has_supra')
            ->allowEmpty('has_supra');

        $validator
            ->time('ecg_hora_1')
            ->allowEmpty('ecg_hora_1');

        $validator
            ->allowEmpty('porta_ecg');

        $validator
            ->allowEmpty('supra_mm');

        $validator
            ->allowEmpty('supra_der');

        $validator
            ->boolean('has_infra')
            ->allowEmpty('has_infra');

        $validator
            ->allowEmpty('infra_mm');

        $validator
            ->allowEmpty('infra_der');

        $validator
            ->boolean('has_tim')
            ->allowEmpty('has_tim');

        $validator
            ->allowEmpty('tim_mm');

        $validator
            ->allowEmpty('tim_der');

        $validator
            ->boolean('has_q_pet')
            ->allowEmpty('has_q_pet');

        $validator
            ->allowEmpty('q_pet_mm');

        $validator
            ->allowEmpty('q_pet_der');

        $validator
            ->boolean('has_bre')
            ->allowEmpty('has_bre');

        $validator
            ->allowEmpty('bre_mm');

        $validator
            ->boolean('has_bavt')
            ->allowEmpty('has_bavt');

        $validator
            ->boolean('has_bro')
            ->allowEmpty('has_bro');

        $validator
            ->allowEmpty('bro_mm');

        $validator
            ->time('ecg_hora_2')
            ->allowEmpty('ecg_hora_2');

        $validator
            ->time('ecg_hora_3')
            ->allowEmpty('ecg_hora_3');

        $validator
            ->boolean('alteracao_dinamica')
            ->allowEmpty('alteracao_dinamica');

        $validator
            ->allowEmpty('enzima_data_1');

        $validator
            ->time('enzima_hora_1')
            ->allowEmpty('enzima_hora_1');

        $validator
            ->allowEmpty('ck_mb_1');

        $validator
            ->allowEmpty('troponima_1');

        $validator
            ->allowEmpty('enzima_data_2');

        $validator
            ->time('enzima_hora_2')
            ->allowEmpty('enzima_hora_2');

        $validator
            ->allowEmpty('ck_mb_2');

        $validator
            ->allowEmpty('troponima_2');

        $validator
            ->allowEmpty('enzima_data_3');

        $validator
            ->time('enzima_hora_3')
            ->allowEmpty('enzima_hora_3');

        $validator
            ->allowEmpty('ck_mb_3');

        $validator
            ->allowEmpty('troponima');

        $validator
            ->allowEmpty('radiologia');

        $validator
            ->allowEmpty('evolucao');

        $validator
            ->allowEmpty('diagnostico_final');

        $validator
            ->allowEmpty('condicao_de_alta');

        $validator
            ->allowEmpty('instrucao_de_alta');

        $validator
            ->allowEmpty('pareceres');

        $validator
            ->allowEmpty('destino');

        $validator
            ->allowEmpty('data_saida');

        $validator
            ->allowEmpty('hora_saida');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('betabloq');

        $validator
            ->allowEmpty('eca');

        $validator
            ->allowEmpty('cm');

        $validator
            ->allowEmpty('epidemia');

        //$validator
            //->date('rvm_data')
            //->allowEmpty('rvm_data');

        $validator
            ->allowEmpty('rvm_pontes');

        //$validator
            //->date('icp_data')
            //->allowEmpty('icp_data');

        $validator
            ->boolean('rvm')
            ->allowEmpty('rvm');

        $validator
            ->integer('icp')
            ->allowEmpty('icp');

        $validator
            ->time('ticagrelor_hora')
            ->allowEmpty('ticagrelor_hora');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
