<?php
namespace App\Model\Table;

use App\Model\Entity\DailyBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * DailyBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Bundles
 */
class DailyBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Bundles', [
            'foreignKey' => 'bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('higienizacao_diaria_com_solucao_dergermante_da_genitalia')
            ->allowEmpty('higienizacao_diaria_com_solucao_dergermante_da_genitalia');

        $validator
            ->boolean('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga')
            ->allowEmpty('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga');

        $validator
            ->boolean('manter_bolsa_coletora_com_capacidade_maxima_de_2_3')
            ->allowEmpty('manter_bolsa_coletora_com_capacidade_maxima_de_2_3');

        $validator
            ->boolean('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento')
            ->allowEmpty('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento');

        $validator
            ->boolean('revisao_diaria_da_indicacao_de_permanencia_do_cateter')
            ->allowEmpty('revisao_diaria_da_indicacao_de_permanencia_do_cateter');

        $validator
            ->boolean('sinal_de_uretrite')
            ->allowEmpty('sinal_de_uretrite');

        $validator
            ->boolean('transporte_realizado_com_clampeamento_do_sistema_coletor')
            ->allowEmpty('transporte_realizado_com_clampeamento_do_sistema_coletor');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization['bundles'] as $key_1 => $bundle)
            {
                foreach ($bundle["daily_bundles"] as $daily_bundle)
                {
                    $bundle_arr = (array) $daily_bundle;
                    $i = 0;

                    $data['total_de_registros']++;

                    foreach ($bundle_arr as $key_2 => $value_2)
                    {
                        $i++;
                        if ($i == 2) //acessa as propriades do obj
                        {
                            foreach ($value_2 as $key_3 => $value_3)
                            {
                                formatArr($value_3, $data, $key_3);
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['bundle_id'], 'Bundles'));
        return $rules;
    }
}
