<?php
namespace App\Model\Table;

use App\Model\Entity\Discharge;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Discharges Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Sectors
 * @property \Cake\ORM\Association\BelongsToMany $Specialties
 */
class DischargesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('discharges');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsToMany('Specialties', [
            'foreignKey'       => 'discharge_id',
            'targetForeignKey' => 'specialty_id',
            'joinTable'        => 'discharges_specialties',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        // ->date('data_previsao_alta_unidade')
        ->allowEmpty('data_previsao_alta_unidade');

        $validator
            ->time('hora_previsao_alta_unidade')
            ->allowEmpty('hora_previsao_alta_unidade');

        $validator
        // ->date('data_decisao_alta_unidade')
        ->allowEmpty('data_decisao_alta_unidade');

        $validator
            ->time('hora_decisao_alta_unidade')
            ->allowEmpty('hora_decisao_alta_unidade');

        $validator
        // ->date('data_saida_unidade')
        ->allowEmpty('data_saida_unidade');

        $validator
            ->time('hora_saida_unidade')
            ->allowEmpty('hora_saida_unidade');

        $validator
            ->allowEmpty('destino_apos_alta');

        $validator
            ->allowEmpty('nome_do_destino_apos_alta');

        $validator
            ->allowEmpty('condicao_clinica');

        $validator
            ->boolean('atendimento_ambulatorial')
            ->allowEmpty('atendimento_ambulatorial');

        $validator
            ->boolean('entregue_o_resumo')
            ->allowEmpty('entregue_o_resumo');

        $validator
            ->boolean('entregue_prescricao_domiciliar')
            ->allowEmpty('entregue_prescricao_domiciliar');

        $validator
            ->boolean('entregue_as_orientacoes')
            ->allowEmpty('entregue_as_orientacoes');

        $validator
            ->boolean('houve_decisao_para_cuidados')
            ->allowEmpty('houve_decisao_para_cuidados');

        $validator
        // ->date('data_decisao_para_cuidados')
        ->allowEmpty('data_decisao_para_cuidados');

        $validator
            ->boolean('realizado_pps2')
            ->allowEmpty('realizado_pps2');

        $validator
            ->allowEmpty('resultado_pps');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['sector_id'], 'Sectors'));
        return $rules;
    }
}
