<?php
namespace App\Model\Table;

use App\Model\Entity\HabitualMedication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * HabitualMedications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $MedicalCares
 */
class HabitualMedicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('habitual_medications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('MedicalCares', [
            'foreignKey' => 'medical_care_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('droga');

        $validator
            ->allowEmpty('apresent');

        $validator
            ->allowEmpty('dose');

        $validator
            ->allowEmpty('intervalo');

        $validator
            ->boolean('mantido')
            ->allowEmpty('mantido');

        $validator
            ->allowEmpty('motivo_de_nao_estar_mantido');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['medical_care_id'], 'MedicalCares'));
        return $rules;
    }
}
