<?php
namespace App\Model\Table;

use App\Model\Entity\ItuPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * ItuPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\HasMany $DailyItuPreventionBundles
 */
class ItuPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('itu_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('DailyItuPreventionBundles', [
            'foreignKey' => 'itu_prevention_bundle_id',
        ]);

        $this->belongsToMany('ImmediateComplications', [
            'foreignKey' => 'itu_prevention_bundle_id',
            'targetForeignKey' => 'immediate_complication_id',
            'joinTable' => 'immediate_complications_itu_prevention_bundles',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        //->date('date_instalation')
        ->requirePresence('date_instalation', 'create')
            ->notEmpty('date_instalation');

        $validator
            ->requirePresence('type_of_device', 'create')
            ->notEmpty('type_of_device');

        $validator
            ->boolean('emergency')
            ->allowEmpty('emergency');

        $validator
            ->boolean('is_risk_of_bleeding_verified')
            ->allowEmpty('is_risk_of_bleeding_verified');

        $validator
            ->boolean('is_the_procedure_prescribed')
            ->allowEmpty('is_the_procedure_prescribed');

        $validator
            ->allowEmpty('device_observation');

        $validator
            ->boolean('proper_handwashing')
            ->allowEmpty('proper_handwashing');

        $validator
            ->boolean('use_of_paramentation')
            ->allowEmpty('use_of_paramentation');

        $validator
            ->boolean('use_of_antisepsis')
            ->allowEmpty('use_of_antisepsis');

        $validator
            ->boolean('use_of_field_with_maxium_barrier')
            ->allowEmpty('use_of_field_with_maxium_barrier');

        $validator
            ->boolean('use_of_sterile_gel')
            ->allowEmpty('use_of_sterile_gel');

        $validator
            ->boolean('suitable_catheter_progression')
            ->allowEmpty('suitable_catheter_progression');

        $validator
            ->boolean('urine_output_cauterization')
            ->allowEmpty('urine_output_cauterization');

        $validator
            ->boolean('adequate_catheter_fixation')
            ->allowEmpty('adequate_catheter_fixation');

        $validator
            ->boolean('confirmation_of_position_with_us')
            ->allowEmpty('confirmation_of_position_with_us');

        $validator
            ->allowEmpty('checklist_observation');

        $validator
            ->integer('number_of_retries')
            ->allowEmpty('number_of_retries');

        $validator
            ->boolean('single_procedure')
            ->allowEmpty('single_procedure');

        $validator
            ->integer('number_of_professionals')
            ->allowEmpty('number_of_professionals');

        $validator
            ->boolean('blood_on_catheter')
            ->allowEmpty('blood_on_catheter');

        $validator
            ->boolean('successful_integration')
            ->allowEmpty('successful_integration');

        $validator
            ->allowEmpty('immediate_complications');

        $validator
        //->date('date_of_withdrawal')
        ->allowEmpty('date_of_withdrawal');

        $validator
        //->date('withdrawal_time')
        ->allowEmpty('withdrawal_time');

        $validator
            ->boolean('accidental_removal')
            ->allowEmpty('accidental_removal');

        $validator
            ->allowEmpty('reason_for_inclusion');

        $validator
        //->time('reinsert_time')
        ->allowEmpty('reinsert_time');

        $validator
        //->date('reinsert_date')
        ->allowEmpty('reinsert_date');

        $validator
            ->boolean('citostimia')
            ->allowEmpty('citostimia');

        $validator
            ->allowEmpty('type');

        $validator
            ->boolean('degermacao_pele_clorohexidine')
            ->allowEmpty('degermacao_pele_clorohexidine');

        $validator
            ->boolean('antisepsia_pele_clorohexidine')
            ->allowEmpty('antisepsia_pele_clorohexidine');

        $validator
            ->boolean('asseptica_durante_procedimento')
            ->allowEmpty('asseptica_durante_procedimento');

        $validator
            ->boolean('ultrasom_durante_procedimento')
            ->allowEmpty('ultrasom_durante_procedimento');

        $validator
            ->boolean('troca_introducar_picc')
            ->allowEmpty('troca_introducar_picc');

        $validator
            ->boolean('curativo_tecnica_esteril')
            ->allowEmpty('curativo_tecnica_esteril');

        $validator
            ->boolean('verificado_risco_dificuldade')
            ->allowEmpty('verificado_risco_dificuldade');

        $validator
            ->allowEmpty('risco_de_dificuldade');

        $validator
            ->boolean('tci_preenchido')
            ->allowEmpty('tci_preenchido');

        $validator
            ->boolean('degermacao_da_genitalia')
            ->allowEmpty('degermacao_da_genitalia');

        $validator
            ->boolean('curativo_tecnica_steril')
            ->allowEmpty('curativo_tecnica_steril');

        $validator
            ->boolean('conectores_cvc')
            ->allowEmpty('conectores_cvc');

        $validator
            ->boolean('radiografia_de_controle')
            ->allowEmpty('radiografia_de_controle');

        $validator
            ->allowEmpty('apos_proce_observacao');

        $validator
            ->allowEmpty('pontuation');

        return $validator;
    }

    //relatorio diario
    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_bundles' => 0,
            'total_dias_no_periodo' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias' => 0,

            //total de procedimentos do tipo cateter vesical cadastrados
            'tot_dispositivos_inseridos' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos' => 0,

            //TOTAL DE TOTOS OS DIAS SOMADOS POR TODOS OS PACIENTES COM ESTE DISPOSITIVO INSTALADO NO PERÍODO
            'tot_tempo_uso_do_bundle' => 0,
            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso' => 0,

        ];
        $percentual = [];

        $data['total_dias_no_periodo'] = $date_after->format("d");

        foreach ($hospitalizations as $hospitalization)
        {
            if (isset($hospitalization["supportive_measures"]))
            {
                foreach ($hospitalization["supportive_measures"] as $key_1 => $supportive_measure)
                {
                    if ($supportive_measure['data_inicio'] >= $date_before &&
                        $supportive_measure['data_termino'] <= $date_after
                    )
                    {
                        $data["tot_dispositivos_inseridos"]++;
                        // if (stripos($supportive_measure['type'], 'cateter vesical') !== false)
                        // {
                        //     $data['tot_procedimento_cateter_vesical']++;

                        //     if (in_array($hospitalization->id, $data['arr_internacao_procedimento_vesical']) == false)
                        //     {
                        //         array_push($data['arr_internacao_procedimento_vesical'], $hospitalization->id);
                        //         $data['tot_internacao_procedimento_vesical']++;
                        //     }
                        // }
                    }
                }
            }

            foreach ($hospitalization["itu_prevention_bundles"] as $bundle)
            {
                //filtra os bundles do tipo vesical
                if (stripos($bundle['type_of_device'], 'vesical de demora') !== false)
                {
                    //deve ser criado um campo de data no bundle diario para ser usada no lugar do bundle principal
                    if ($bundle['date_instalation'] >= $date_before &&
                        $bundle['date_instalation'] <= $date_after
                    )
                    {
                        $data['tot_tempo_uso_do_bundle'] += $bundle['date_instalation']->diff($bundle['date_of_withdrawal'])->d;

                        foreach ($bundle["daily_itu_prevention_bundles"] as $daily_bundle)
                        {
                            $bundle_arr = (array) $daily_bundle;
                            $i = 0;

                            $data['total_de_bundles']++;

                            foreach ($bundle_arr as $key_2 => $value_2)
                            {
                                $i++;
                                if ($i == 2) //acessa as propriades do obj
                                {
                                    foreach ($value_2 as $key_3 => $value_3)
                                    {
                                        //$data[$key_3] = $value_3;
                                        formatArr($value_3, $data, $key_3);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['percentual']) && isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['soma'] = 0;
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_bundles']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);

                //calcula o total
                if (count($data[$key]['arr']) > 0)
                {
                    foreach ($data[$key]['arr'] as $attr)
                    {
                        if (is_numeric($attr))
                        {
                            $data[$key]['soma'] += $attr;
                        }
                    }
                }
            }
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias'] = ($data['total_de_bundles'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias'] = round($data['percen_bundles_por_dias'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos'] = ($data['total_de_bundles'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos'] = round($data['percen_bundles_por_procedimentos'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['tot_bundles_por_tempo_de_uso'] = ($data['total_de_bundles'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso'] = round($data['tot_bundles_por_tempo_de_uso'], 2);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
