<?php
namespace App\Model\Table;

use App\Model\Entity\MedicalOpinionRequest;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * MedicalOpinionRequests Model
 *
 * @property \Cake\ORM\Association\BelongsTo $RequestedSpecialties
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $MedicalOpinionAnswer
 */
class MedicalOpinionRequestsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medical_opinion_requests');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');
        $this->belongsTo('Specialties', [
            'foreignKey' => 'specialty_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER',
        ]);
        $this->hasMany('MedicalOpinionAnswers', [
            'foreignKey' => 'medical_opinion_request_id',
        ]);
    }

    public function relatorioMedicalOpinion($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'tab_parecer_setor' => [],
            'tab_especialidade_destino' => [],

        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["medical_opinion_requests"] as $key_1 => $neonatal)
            {
                if (isset($neonatal['sector']))
                {
                    $name = $neonatal['sector']['name'];
                    $id = $neonatal['sector']['id'];

                    if (isset($data['tab_parecer_setor'][$id]))
                    {
                        $data['tab_parecer_setor'][$id]['total']++;
                    }
                    else
                    {
                        $data['tab_parecer_setor'][$id]['total'] = 1;
                        $data['tab_parecer_setor'][$id]['name'] = $name;
                    }
                }

                if (isset($neonatal['specialty']))
                {
                    $name = $neonatal['specialty']['name'];
                    $id = $neonatal['specialty']['id'];

                    if (isset($data['tab_especialidade_destino'][$id]))
                    {
                        $data['tab_especialidade_destino'][$id]['total']++;
                    }
                    else
                    {
                        $data['tab_especialidade_destino'][$id]['total'] = 1;
                        $data['tab_especialidade_destino'][$id]['name'] = $name;
                    }
                }

                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);
                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('motive', 'create')
            ->notEmpty('motive');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['specialty_id'], 'Specialties'));
        $rules->add($rules->existsIn(['user_id'], 'Users'));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
