<?php
namespace App\Model\Table;

use App\Model\Entity\MedicationDescription;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicationDescriptions Model
 *
 * @property \Cake\ORM\Association\HasMany $PrescriptionMedications
 * @property \Cake\ORM\Association\HasMany $SystemMedications
 */
class MedicationDescriptionsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medication_descriptions');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('PrescriptionMedications', [
            'foreignKey' => 'medication_description_id'
        ]);
        $this->hasMany('SystemMedications', [
            'foreignKey' => 'medication_description_id'
        ]);

        $this->belongsToMany('RestrictedSectors', [
             'className' => 'Sectors',
             'foreignKey' => 'medication_description_id',
             'targetForeignKey' => 'sector_id',
             'joinTable' => 'medication_restricted_sectors'
        ]);

        $this->belongsToMany('RestrictedProfessionals', [
             'className' => 'Professionals',
             'foreignKey' => 'medication_description_id',
             'targetForeignKey' => 'professional_id',
             'joinTable' => 'medication_restricted_professionals'
        ]);

        $this->belongsToMany('RestrictedSpecialties', [
             'className' => 'Specialties',
             'foreignKey' => 'medication_description_id',
             'targetForeignKey' => 'specialty_id',
             'joinTable' => 'medication_restricted_specialties'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        $validator
            ->allowEmpty('category');

        $validator
            ->allowEmpty('channel');

        $validator
            ->allowEmpty('frequency');

        $validator
            ->date('start_date')
            ->allowEmpty('start_date');

        $validator
            ->date('end_date')
            ->allowEmpty('end_date');

        $validator
            ->boolean('is_antibiotic')
            ->allowEmpty('is_antibiotic');

        $validator
            ->allowEmpty('justificativa_antibiotico');

        $validator
            ->time('start_time')
            ->allowEmpty('start_time');

        $validator
            ->integer('using_time')
            ->allowEmpty('using_time');

        $validator
            ->boolean('imediate_start')
            ->allowEmpty('imediate_start');

        $validator
            ->allowEmpty('observation');

        $validator
            ->allowEmpty('presentation');

        $validator
            ->integer('quantity')
            ->allowEmpty('quantity');

        $validator
            ->allowEmpty('schedule');

        $validator
            ->boolean('is_surveillance_signed')
            ->allowEmpty('is_surveillance_signed');

        $validator
            ->allowEmpty('surveillance_signaling');

        $validator
            ->allowEmpty('special_conditioning');

        $validator
            ->boolean('is_restricted_by_sectors')
            ->allowEmpty('is_restricted_by_sectors');

        $validator
            ->boolean('is_restricted_by_users')
            ->allowEmpty('is_restricted_by_users');

        $validator
            ->boolean('accepts_devolution')
            ->allowEmpty('accepts_devolution');

        $validator
            ->boolean('controlled_drug')
            ->allowEmpty('controlled_drug');

        $validator
            ->decimal('unitary_price')
            ->allowEmpty('unitary_price');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }
}
