<?php
namespace App\Model\Table;

use App\Model\Entity\NutritionalAssessment;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * NutritionalAssessments Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NutritionalAssessmentsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('nutritional_assessments');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('percentual_de_energia_programado_atingido')
            ->allowEmpty('percentual_de_energia_programado_atingido');

        $validator
            ->boolean('imc_e_menor_do_que_20_5')
            ->allowEmpty('imc_e_menor_do_que_20_5');

        $validator
            ->boolean('paciente_perdeu_peso_nos_ultimos_3_meses')
            ->allowEmpty('paciente_perdeu_peso_nos_ultimos_3_meses');

        $validator
            ->boolean('paciente_teve_sua_ingestao_dietetica')
            ->allowEmpty('paciente_teve_sua_ingestao_dietetica');

        $validator
            ->boolean('paciente_e_gravemente_doente')
            ->allowEmpty('paciente_e_gravemente_doente');

        $validator
            ->boolean('estado_nutricional_normal')
            ->allowEmpty('estado_nutricional_normal');

        $validator
            ->boolean('perda_e_peso_maior_5_em_3_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_3_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_2_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_2_meses');

        $validator
            ->boolean('perda_e_peso_maior_5_em_1_meses')
            ->allowEmpty('perda_e_peso_maior_5_em_1_meses');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'tot_patient_suspeita_me' => [
                'arr' => [],
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["nutritional_assessments"] as $key_1 => $protocol)
            {
                if (!in_array($hospitalization['patient_id'], $data['tot_patient_suspeita_me']['arr']))
                {
                    array_push($data['tot_patient_suspeita_me']['arr'], $hospitalization['patient_id']);
                }

                $arr = (array) $protocol;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
