<?php
namespace App\Model\Table;

use App\Model\Entity\ObtainedOrgansFromCorpse;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ObtainedOrgansFromCorpses Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SuspectedMeProtocols
 */
class ObtainedOrgansFromCorpsesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('obtained_organs_from_corpses');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsTo('SuspectedMeProtocols', [
            'foreignKey' => 'suspected_me_protocol_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        $validator
            ->time('tempo_apos_parada_cardiaca')
            ->allowEmpty('tempo_apos_parada_cardiaca');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['suspected_me_protocol_id'], 'SuspectedMeProtocols'));
        return $rules;
    }
}
