<?php
namespace App\Model\Table;

use App\Model\Entity\PavDiaryChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * PavDiaryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $PavPreventionBundles
 */
class PavDiaryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pav_diary_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('PavPreventionBundles', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('elevacao_cabeceira')
            ->allowEmpty('elevacao_cabeceira');

        $validator
            ->boolean('avaliacao_ventilatoria_diaria')
            ->allowEmpty('avaliacao_ventilatoria_diaria');

        $validator
            ->boolean('manutencao_da_pressao_balonete')
            ->allowEmpty('manutencao_da_pressao_balonete');

        $validator
            ->boolean('higiene_bucal')
            ->allowEmpty('higiene_bucal');

        $validator
            ->boolean('inicio_da_nutricao')
            ->allowEmpty('inicio_da_nutricao');

        $validator
            ->boolean('posicao_tubo_checado')
            ->allowEmpty('posicao_tubo_checado');

        $validator
            ->boolean('pro_cinetico')
            ->allowEmpty('pro_cinetico');

        $validator
            ->boolean('presencao_de_nausea')
            ->allowEmpty('presencao_de_nausea');

        $validator
            ->boolean('gastroparesia')
            ->allowEmpty('gastroparesia');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    //relatorio diario
    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_bundles' => 0,
            'total_dias_no_periodo' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias' => 0,

            //total de procedimentos do tipo cateter vesical cadastrados
            'tot_dispositivos_inseridos' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos' => 0,

            //TOTAL DE TOTOS OS DIAS SOMADOS POR TODOS OS PACIENTES COM ESTE DISPOSITIVO INSTALADO NO PERÍODO
            'tot_tempo_uso_do_bundle' => 0,
            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso' => 0,

        ];

        $data['total_dias_no_periodo'] = $date_after->format("d");

        foreach ($hospitalizations as $hospitalization)
        {
            if (isset($hospitalization["supportive_measures"]))
            {
                foreach ($hospitalization["supportive_measures"] as $key_1 => $supportive_measure)
                {
                    if ($supportive_measure['data_inicio'] >= $date_before &&
                        $supportive_measure['data_termino'] <= $date_after
                    )
                    {
                        $data["tot_dispositivos_inseridos"]++;
                        // if (stripos($supportive_measure['type'], 'cateter vesical') !== false)
                        // {
                        //     $data['tot_procedimento_cateter_vesical']++;

                        //     if (in_array($hospitalization->id, $data['arr_internacao_procedimento_vesical']) == false)
                        //     {
                        //         array_push($data['arr_internacao_procedimento_vesical'], $hospitalization->id);
                        //         $data['tot_internacao_procedimento_vesical']++;
                        //     }
                        // }
                    }
                }
            }

            foreach ($hospitalization["pav_prevention_bundles"] as $bundle)
            {
                //deve ser criado um campo de data no bundle diario para ser usada no lugar do bundle principal
                if ($bundle['data_da_instalacao'] >= $date_before &&
                    $bundle['data_da_instalacao'] <= $date_after
                )
                {
                    if (verifyDate($bundle['data_da_instalacao']) &&
                        verifyDate($bundle['data_da_retirada']))
                    {
                        $data['tot_tempo_uso_do_bundle'] += $bundle['data_da_instalacao']->diff($bundle['data_da_retirada'])->d;
                    }

                    foreach ($bundle["pav_diary_checklists"] as $daily_bundle)
                    {
                        $bundle_arr = (array) $daily_bundle;
                        $i = 0;

                        $data['total_de_bundles']++;

                        foreach ($bundle_arr as $key_2 => $value_2)
                        {
                            $i++;
                            if ($i == 2) //acessa as propriades do obj
                            {
                                foreach ($value_2 as $key_3 => $value_3)
                                {
                                    //$data[$key_3] = $value_3;
                                    formatArr($value_3, $data, $key_3);
                                }
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['percentual']) && isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['soma'] = 0;
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_bundles']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);

                //calcula o total
                if (count($data[$key]['arr']) > 0)
                {
                    foreach ($data[$key]['arr'] as $attr)
                    {
                        if (is_numeric($attr))
                        {
                            $data[$key]['soma'] += $attr;
                        }
                    }
                }
            }
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias'] = ($data['total_de_bundles'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias'] = round($data['percen_bundles_por_dias'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos'] = ($data['total_de_bundles'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos'] = round($data['percen_bundles_por_procedimentos'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['tot_bundles_por_tempo_de_uso'] = ($data['total_de_bundles'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso'] = round($data['tot_bundles_por_tempo_de_uso'], 2);
        }

        return $data;
    }

/**
 * Returns a rules checker object that will be used for validating
 * application integrity.
 *
 * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
 * @return \Cake\ORM\RulesChecker
 */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['pav_prevention_bundle_id'], 'PavPreventionBundles'));
        return $rules;
    }
}
