<?php
namespace App\Model\Table;

use App\Model\Entity\PrescriptionMedication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PrescriptionMedications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $MedicationDescriptions
 * @property \Cake\ORM\Association\BelongsTo $Prescriptions
 */
class PrescriptionMedicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('prescription_medications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Prescriptions', [
            'foreignKey' => 'prescription_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsTo('SystemMedications', [
            'foreignKey' => 'system_medication_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsToMany('Cultures', [
            'foreignKey' => 'prescription_medication_id',
            'targetForeignKey' => 'culture_id',
            'joinTable' => 'prescription_medications_cultures'
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['prescription_id'], 'Prescriptions'));
        return $rules;
    }
}
