<?php
namespace App\Model\Table;

use App\Model\Entity\RiskFactor;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * RiskFactors Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $ClinicTevProtocols
 */
class RiskFactorsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('risk_factors');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('ClinicTevProtocols', [
            'foreignKey' => 'risk_factor_id',
            'targetForeignKey' => 'clinic_tev_protocol_id',
            'joinTable' => 'clinic_tev_protocols_risk_factors'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        return $validator;
    }
}
