<?php
namespace App\Model\Table;

use App\Model\Entity\SepseProtocol;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SepseProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsTo $SofaEscores
 */
class SepseProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sepse_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsTo('SofaEscores', [
            'foreignKey' => 'sofa_escore_id',
        ]);

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('hipotensao')
            ->allowEmpty('hipotensao');

        $validator
            ->boolean('taquipneia')
            ->allowEmpty('taquipneia');

        $validator
            ->boolean('alteracao_estado_mental')
            ->allowEmpty('alteracao_estado_mental');

        $validator
            ->boolean('pneumonia')
            ->allowEmpty('pneumonia');

        $validator
            ->boolean('infeccao_urinaria')
            ->allowEmpty('infeccao_urinaria');

        $validator
            ->boolean('infeccao_abdominal')
            ->allowEmpty('infeccao_abdominal');

        $validator
            ->boolean('meningite')
            ->allowEmpty('meningite');

        $validator
            ->boolean('endocardite')
            ->allowEmpty('endocardite');

        $validator
            ->boolean('pele_partes_moles')
            ->allowEmpty('pele_partes_moles');

        $validator
            ->boolean('infeccao_protese')
            ->allowEmpty('infeccao_protese');

        $validator
            ->boolean('infeccao_ossea')
            ->allowEmpty('infeccao_ossea');

        $validator
            ->boolean('infeccao_ferida_operatoria')
            ->allowEmpty('infeccao_ferida_operatoria');

        $validator
            ->boolean('infeccao_corrente_sanguinea')
            ->allowEmpty('infeccao_corrente_sanguinea');

        $validator
            ->allowEmpty('outras_infeccoes');

        $validator
            ->boolean('sem_foco_definido')
            ->allowEmpty('sem_foco_definido');

        $validator
            ->boolean('infeccao_nao_complicada')
            ->allowEmpty('infeccao_nao_complicada');

        $validator
            ->boolean('sepse')
            ->allowEmpty('sepse');

        $validator
            ->boolean('choque_septico')
            ->allowEmpty('choque_septico');

        $validator
            ->boolean('afastado_sepse')
            ->allowEmpty('afastado_sepse');

        $validator
            ->boolean('sepse_choque_septico')
            ->allowEmpty('sepse_choque_septico');

        $validator
            ->boolean('coletar_exame')
            ->allowEmpty('coletar_exame');

        $validator
        // ->date('coletar_exame_data')
        ->allowEmpty('coletar_exame_data');

        $validator
            ->time('coletar_exame_hora')
            ->allowEmpty('coletar_exame_hora');

        $validator
            ->boolean('preservar_antibio')
            ->allowEmpty('preservar_antibio');

        $validator
            ->time('preservar_antibio_hora')
            ->allowEmpty('preservar_antibio_hora');

        $validator
        // ->date('preservar_anti_data')
        ->allowEmpty('preservar_anti_data');

        $validator
            ->boolean('encerrar_atendimento')
            ->allowEmpty('encerrar_atendimento');

        $validator
        // ->date('encerrar_atendimento_data')
        ->allowEmpty('encerrar_atendimento_data');

        $validator
            ->time('encerrar_atendimento_hora')
            ->allowEmpty('encerrar_atendimento_hora');

        $validator
            ->boolean('paciente_nao_tem_disfuncao')
            ->allowEmpty('paciente_nao_tem_disfuncao');

        $validator
            ->boolean('pas_menor_que_90')
            ->allowEmpty('pas_menor_que_90');

        $validator
            ->boolean('relacao_pao')
            ->allowEmpty('relacao_pao');

        $validator
            ->boolean('rebaixamento_do_nivel')
            ->allowEmpty('rebaixamento_do_nivel');

        $validator
            ->boolean('creatina')
            ->allowEmpty('creatina');

        $validator
            ->boolean('bilirrubina')
            ->allowEmpty('bilirrubina');

        $validator
            ->boolean('contagem_de_plaquetas')
            ->allowEmpty('contagem_de_plaquetas');

        $validator
            ->boolean('lactato_acima_do_valor')
            ->allowEmpty('lactato_acima_do_valor');

        $validator
            ->boolean('coagulopatia')
            ->allowEmpty('coagulopatia');

        $validator
        // ->date('data_primeira_disfuncao')
        ->allowEmpty('data_primeira_disfuncao');

        $validator
            ->time('hora_primeira_disfuncao')
            ->allowEmpty('hora_primeira_disfuncao');

        $validator
            ->allowEmpty('caso_confirmado_como');

        $validator
        // ->date('destino_data')
        ->allowEmpty('destino_data');

        $validator
            ->time('destino_hora')
            ->allowEmpty('destino_hora');

        $validator
            ->boolean('destino_liberacao_para_tratamento')
            ->allowEmpty('destino_liberacao_para_tratamento');

        $validator
            ->boolean('destino_internacao')
            ->allowEmpty('destino_internacao');

        $validator
            ->time('reconhecimento_sepse_hora')
            ->allowEmpty('reconhecimento_sepse_hora');

        $validator
        // ->date('reconhecimento_sepse_data')
        ->allowEmpty('reconhecimento_sepse_data');

        $validator
            ->time('antibioticoterapia_hora')
            ->allowEmpty('antibioticoterapia_hora');

        $validator
        // ->date('antibioticoterapia_data')
        ->allowEmpty('antibioticoterapia_data');

        $validator
            ->allowEmpty('classificacao');

        $validator
            ->allowEmpty('delta_de_cultura');

        $validator
            ->allowEmpty('pontuacao_sofa_d1_score');

        $validator
            ->allowEmpty('pontuacao_maxima_sofa');

        $validator
            ->allowEmpty('desfecho');

        $validator
        // ->date('hemocultura_data')
        ->allowEmpty('hemocultura_data');

        $validator
            ->time('hemocultura_hora')
            ->allowEmpty('hemocultura_hora');

        $validator
        // ->date('qsofa_data')
        ->allowEmpty('qsofa_data');

        $validator
            ->time('qsofa_hora')
            ->allowEmpty('qsofa_hora');

        $validator
            ->allowEmpty('lactato');

        $validator
            ->time('lactato_hora')
            ->allowEmpty('lactato_hora');

        $validator
            ->allowEmpty('delta_de_antibiotico');

        $validator
            ->allowEmpty('taxa_clareamento_lactato');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        $rules->add($rules->existsIn(['sofa_escore_id'], 'SofaEscores'));
        return $rules;
    }
}
