<?php
namespace App\Model\Table;

use App\Model\Entity\SupportiveMeasure;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * SupportiveMeasures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SupportiveMeasuresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('supportive_measures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('Measures', [
            'foreignKey' => 'supportive_measure_id',
        ]);

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        //->date('data_inicio')
        ->requirePresence('data_inicio', 'create')
            ->allowEmpty('data_inicio');

        $validator
        //->date('data_termino')
        ->requirePresence('data_termino', 'create')
            ->allowEmpty('data_termino');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->requirePresence('type', 'create')
            ->notEmpty('type');

        return $validator;
    }

    public function getRelatorioPav($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'type' => [
                'arr' => [],
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["supportive_measures"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        foreach ($data['type']['arr'] as $key => $value)
        {
            $cont_orotraqueal = 0;
            if ($value == 'Tubo orotraqueal')
            {
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
