<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Admission']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['controller' => 'Screenings', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['controller' => 'Screenings', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Habitual Medications']), ['controller' => 'HabitualMedications', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Habitual Medication']), ['controller' => 'HabitualMedications', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hpps']), ['controller' => 'Hpps', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hpp']), ['controller' => 'Hpps', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Physical Exams']), ['controller' => 'PhysicalExams', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Physical Exam']), ['controller' => 'PhysicalExams', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Relevant Complementary Exams']), ['controller' => 'RelevantComplementaryExams', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Relevant Complementary Exam']), ['controller' => 'RelevantComplementaryExams', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="admissions index col-md-10 columns content">
    <h3>Admissions</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('motivo') ?></th>
                <th><?= $this->Paginator->sort('hda') ?></th>
                <th><?= $this->Paginator->sort('int_hb') ?></th>
                <th><?= $this->Paginator->sort('int_cti') ?></th>
                <th><?= $this->Paginator->sort('equipe_assistente') ?></th>
                <th><?= $this->Paginator->sort('alergias') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($admissions as $admission): ?>
            <tr>
                <td><?= $this->Number->format($admission->id) ?></td>
                <td><?= h($admission->motivo) ?></td>
                <td><?= h($admission->hda) ?></td>
                <td><?= h($admission->int_hb) ?></td>
                <td><?= h($admission->int_cti) ?></td>
                <td><?= h($admission->equipe_assistente) ?></td>
                <td><?= h($admission->alergias) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $admission->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $admission->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $admission->id], ['confirm' => __('Are you sure you want to delete # {0}?', $admission->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>