
<?php
if ($current_state == 'internacao')
{
    echo $this->element('internacao-menu');
}
else
{
    echo $this->element('screening-menu');
}

$data_arr = [];
foreach ($bundles as $bundle)
{
    foreach ($bundle['itu_prevention_bundles'] as $value)
    {
        $value["tipo_tabela"] = "itu_prevention_bundles";

        if (!array_key_exists($value->created->format("Y-m-d"), $data_arr))
        {
            $data_arr[$value->created->format("Y-m-d")] = [];
        }
        array_push($data_arr[$value->created->format("Y-m-d")], $value);
    }
    foreach ($bundle['bundles'] as $value)
    {
        $value["tipo_tabela"] = "bundles";

        if (!array_key_exists($value->created->format("Y-m-d"), $data_arr))
        {
            $data_arr[$value->created->format("Y-m-d")] = [];
        }
        array_push($data_arr[$value->created->format("Y-m-d")], $value);
    }
    foreach ($bundle['pav_prevention_bundles'] as $value)
    {
        $value["tipo_tabela"] = "pav_prevention_bundles";

        if (!array_key_exists($value->created->format("Y-m-d"), $data_arr))
        {
            $data_arr[$value->created->format("Y-m-d")] = [];
        }
        array_push($data_arr[$value->created->format("Y-m-d")], $value);
    }
    foreach ($bundle['safe_surgery_bundles'] as $value)
    {
        $value["tipo_tabela"] = "safe_surgery_bundles";

        if (!array_key_exists($value->created->format("Y-m-d"), $data_arr))
        {
            $data_arr[$value->created->format("Y-m-d")] = [];
        }
        array_push($data_arr[$value->created->format("Y-m-d")], $value);
    }

    krsort($data_arr);
}

?>
<div class="row">

<div class="bundles index col-md-8 columns content">
    <!-- <h3>Bundles</h3> -->
        <br>

    <div class="btn-group">
      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            Novo
            <span class="caret"></span>
        </button>
        <ul class="dropdown-menu">
            <li>
                <?=$this->Html->link('Cateter Vascular', ['controller' => 'Bundles', 'action' => 'add', '_full' => true]);?>
            </li>
            <li>
                <?=$this->Html->link('Prevenção de PAV', ['controller' => 'pavPreventionBundles', 'action' => 'add', '_full' => true]);?>
            </li>
            <li>
                <?=$this->Html->link('Prevenção de ITU por Cateter', ['controller' => 'itu_prevention_bundles', 'action' => 'add', '_full' => true]);?>
            </li>
            <li>
                <?=$this->Html->link('Cirurgia Segura', ['controller' => 'safeSurgeryBundles', 'action' => 'add', 1, '_full' => true]);?>
            </li>
        </ul>
    </div>
    <br>

    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Tipo</th>
                <th>Data de instalação </th>
                <th>Hora </th>
                <th class="actions"> <?=__('Ações')?> </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data_arr as $key => $data_arr_val): ?>
                <?php foreach ($data_arr_val as $value): ?>
                    <?php if ($value['tipo_tabela'] == "itu_prevention_bundles"): ?>
                       <?php $itu_prevention_bundles = $value;?>
                        <tr>
                            <td>Passagem de CVD e Prevenção de ITU por Cateter</td>
                            <td>
                                <?php if (isset($itu_prevention_bundles->date_instalation)): ?>
                                        <?=h($itu_prevention_bundles->date_instalation->format('d/m/Y'))?>
                                <?php endif;?>
                            </td>
                            <td>
                                <?php if (isset($itu_prevention_bundles->hour_instalation)): ?>
                                        <?=h($itu_prevention_bundles->hour_instalation->format('h:i'))?>
                                <?php endif;?>
                            </td>


                            <td class="actions" style="white-space:nowrap">

                                <?=$this->Html->link(__('Editar'), ['controller' => 'ItuPreventionBundles', 'action' => 'edit', $itu_prevention_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Html->link(__('Bundle Diário'), ['controller' => 'dailyItuPreventionBundles', 'action' => 'index', $itu_prevention_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Form->postLink(__('Deletar'), ['controller' => 'ItuPreventionBundles', 'action' => 'delete', $itu_prevention_bundles->id], ['confirm' => __('Tem certeza que deseja deletar o bundle?', $itu_prevention_bundles->id), 'class' => 'btn btn-danger btn-xs'])?>
                            </td>
                        </tr>
                    <?php elseif ($value['tipo_tabela'] == "bundles"): ?>
                       <?php $cateter_insertion = $value;?>

                        <?php if ($cateter_insertion->is_utu): ?>
                            <tr>
                                <td>Passagem de CVD e Prevenção de ITU por Cateter</td>
                                <td><?=h($cateter_insertion->date_instalation->format('d/m/Y'))?></td>
                                <td><?=h($cateter_insertion->hour_instalation->format('h:i'))?></td>

                                <td class="actions" style="white-space:nowrap">

                                    <?=$this->Html->link(__('Editar'), ['action' => 'edit', $cateter_insertion->id], ['class' => 'btn btn-primary btn-xs'])?>
                                    <?=$this->Html->link(__('Bundle Diário'), ['controller' => 'dailyBundles', 'action' => 'index', $cateter_insertion->id, 1], ['class' => 'btn btn-primary btn-xs'])?>
                                    <?=$this->Form->postLink(__('Deletar'), ['action' => 'delete', $cateter_insertion->id], ['confirm' => __('Tem certeza que deseja deletar o bundle?', $cateter_insertion->id), 'class' => 'btn btn-danger btn-xs'])?>
                                </td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <td>Cateter Vascular</td>

                                <td>
                                    <?php if (isset($cateter_insertion->date_instalation)): ?>
                                        <?=h($cateter_insertion->date_instalation->format('d/m/Y'));?>
                                    <?php endif;?>
                                </td>
                                <td>
                                    <?php if (isset($cateter_insertion->hour_instalation)): ?>
                                        <?=h($cateter_insertion->hour_instalation->format('h:i'));?>
                                    <?php endif;?>
                                </td>

                                <td class="actions" style="white-space:nowrap">

                                    <?=$this->Html->link(__('Editar'), ['action' => 'edit', $cateter_insertion->id], ['class' => 'btn btn-primary btn-xs'])?>
                                    <?=$this->Html->link(__('Bundle Diário'), ['controller' => 'dailyBundles', 'action' => 'index', $cateter_insertion->id], ['class' => 'btn btn-primary btn-xs'])?>
                                    <?=$this->Form->postLink(__('Deletar'), ['action' => 'delete', $cateter_insertion->id], ['confirm' => __('Tem certeza que deseja deletar o bundle?', $cateter_insertion->id), 'class' => 'btn btn-danger btn-xs'])?>
                                </td>
                            </tr>
                        <?php endif;?>
                    <?php elseif ($value['tipo_tabela'] == "pav_prevention_bundles"): ?>
                        <?php $pav_prevention_bundles = $value;?>
                        <tr>
                            <td>Prevenção de PAV</td>
                            <td><?=h($pav_prevention_bundles->data_da_instalacao->format('d/m/Y'))?></td>
                            <td><?=h($pav_prevention_bundles->hora_da_instalacao->format('h:i'))?></td>

                            <td class="actions" style="white-space:nowrap">

                                <?=$this->Html->link(__('Editar'), ['controller' => 'PavPreventionBundles', 'action' => 'edit', $pav_prevention_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Html->link(__('Bundle Diário'), ['controller' => 'PavDiaryChecklists', 'action' => 'index', $pav_prevention_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Form->postLink(__('Deletar'), ['controller' => 'PavPreventionBundles', 'action' => 'delete', $pav_prevention_bundles->id], ['confirm' => __('Tem certeza que deseja deletar o bundle?', $pav_prevention_bundles->id), 'class' => 'btn btn-danger btn-xs'])?>
                            </td>
                        </tr>
                    <?php elseif ($value['tipo_tabela'] == "safe_surgery_bundles"): ?>
                        <?php $safe_surgery_bundles = $value;?>
                        <tr>
                            <td>Cirurgia Segura</td>
                            <td><?=h($safe_surgery_bundles->created->format('d/m/Y'))?></td>
                            <td><?=h($safe_surgery_bundles->created->format('h:i'))?></td>
                            <td class="actions" style="white-space:nowrap">

                                <?=$this->Html->link(__('Editar'), ['controller' => 'SafeSurgeryBundles', 'action' => 'edit', $safe_surgery_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Html->link(__('Bundle Diário'), ['controller' => 'SafeSurgeryDiaryBundles', 'action' => 'index', $safe_surgery_bundles->id], ['class' => 'btn btn-primary btn-xs'])?>
                                <?=$this->Form->postLink(__('Deletar'), ['controller' => 'SafeSurgeryBundles', 'action' => 'delete', $safe_surgery_bundles->id], ['confirm' => __('Tem certeza que deseja deletar o bundle?', $safe_surgery_bundles->id), 'class' => 'btn btn-danger btn-xs'])?>
                            </td>
                        </tr>
                    <?php endif;?>
                <?php endforeach;?>
            <?php endforeach;?>
            ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?=$this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape' => false])?>
                <?=$this->Paginator->numbers(['escape' => false])?>
                <?=$this->Paginator->next(__('Próximo') . ' &raquo;', ['escape' => false])?>
            </ul>

        </div>
    </center>
</div>
</div>

<?php if ($current_state == "internacao"): ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

            var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Bundles</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>

<?php else: ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
           var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

           var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

           var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';


            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Bundle</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>
<?php endif;?>

