<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('New Discharges Specialty'), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Specialties'), ['controller' => 'Specialties', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Specialty'), ['controller' => 'Specialties', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Discharges'), ['controller' => 'Discharges', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Discharge'), ['controller' => 'Discharges', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="dischargesSpecialties index large-9 medium-8 columns content">
    <h3><?= __('Discharges Specialties') ?></h3>
    <table cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('specialty_id') ?></th>
                <th><?= $this->Paginator->sort('discharge_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($dischargesSpecialties as $dischargesSpecialty): ?>
            <tr>
                <td><?= $this->Number->format($dischargesSpecialty->id) ?></td>
                <td><?= $dischargesSpecialty->has('specialty') ? $this->Html->link($dischargesSpecialty->specialty->name, ['controller' => 'Specialties', 'action' => 'view', $dischargesSpecialty->specialty->id]) : '' ?></td>
                <td><?= $dischargesSpecialty->has('discharge') ? $this->Html->link($dischargesSpecialty->discharge->id, ['controller' => 'Discharges', 'action' => 'view', $dischargesSpecialty->discharge->id]) : '' ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $dischargesSpecialty->id]) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $dischargesSpecialty->id]) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $dischargesSpecialty->id], ['confirm' => __('Are you sure you want to delete # {0}?', $dischargesSpecialty->id)]) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
