<?php

    if ($ituPreventionBundle['date_instalation']) {
        $ituPreventionBundle['date_instalation'] =  $ituPreventionBundle['date_instalation']->i18nFormat('dd-MM-yyyy');
    }

    if ($ituPreventionBundle['hour_instalation']) {
        $ituPreventionBundle['hour_instalation'] =  $ituPreventionBundle['hour_instalation']->i18nFormat('HH:mm');
    }

    if ($ituPreventionBundle['date_of_withdrawal']) {
        $ituPreventionBundle['date_of_withdrawal'] =  $ituPreventionBundle['date_of_withdrawal']->i18nFormat('dd-MM-yyyy');
    }

    if ($ituPreventionBundle['withdrawal_time']) {
        $ituPreventionBundle['withdrawal_time'] =  $ituPreventionBundle['withdrawal_time']->i18nFormat('HH:mm');
    }

?>

<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Bundle de Prevenção de ITU</h1>
        </div>
        
</div>

<div class="ituPreventionBundles form col-md-12 columns content">
<br>
  
        <?php

            $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

            $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);
        

            echo '<div class="col-sm-6 data-field">';
              echo '<b>Data de Instalação:</b>'.$ituPreventionBundle['date_instalation'];
            echo '</div>';


            echo '<div class="col-sm-6 data-field">';
              echo '<b>Hora de Instalação:</b>'.$ituPreventionBundle['hour_instalation'];
            echo '</div>';


            echo "<div class='col-md-12 no-padding'>";

                echo "<br><legend class='big-title'>Pré-procedimento:</legend>";
                
                
                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Tipo de Dispositivo:</b>'.$ituPreventionBundle['type_of_device'];
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['emergency']){
                    echo $checked_img.'<b>Procedimento emergencial</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento emergencial</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['is_risk_of_bleeding_verified']){
                    echo $checked_img.'<b>Risco de sangramento verificado</b>';
                  }else{
                    echo $not_checked_img.'<b>Risco de sangramento verificado</b>';
                  }
                echo '</div>';


                 echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['is_the_procedure_prescribed']){
                    echo $checked_img.'<b>Procedimento prescrito</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento prescrito</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['is_the_procedure_prescribed']){
                    echo $checked_img.'<b>Procedimento prescrito</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento prescrito</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-12">';
                  echo $this->Form->input('device_observation', [ 'type'=>'textarea', 'label'=>['text'=>'Observação do dispositivo:', 'class'=>'form-input'] ]);
                echo '</div>';

            echo '</div>';

            echo "<div class='col-md-12 no-padding'>";

                echo "<br><legend class='big-title'>Durante o procedimento:</legend>";



                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['proper_handwashing']){
                    echo $checked_img.'<b>Higienização adequada das mãos com clorexidina ou gel alcoólico</b>';
                  }else{
                    echo $not_checked_img.'<b>Higienização adequada das mãos com clorexidina ou gel alcoólico</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_paramentation']){
                    echo $checked_img.'<b>Uso de paramentação: gorro, máscara e luvas estéreis</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de paramentação: gorro, máscara e luvas estéreis</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-12 no-padding">';
                  echo '<div class="col-sm-6 data-field">';
                    if($ituPreventionBundle['use_of_antisepsis']){
                      echo $checked_img.'<b>Uso de antissepsia</b>';
                    }else{
                      echo $not_checked_img.'<b>Uso de antissepsia</b>';
                    }
                  echo '</div>';  


                  echo '<div class="col-sm-6 data-field">';
                    if($ituPreventionBundle['degermacao_da_genitalia']){
                      echo $checked_img.'<b>Uso de degermação da cavidade genitália com clorexidina aquosa</b>';
                    }else{
                      echo $not_checked_img.'<b>Uso de degermação da cavidade genitália com clorexidina aquosa</b>';
                    }
                  echo '</div>';    
                echo '</div>'; 


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_field_with_maxium_barrier']){
                    echo $checked_img.'<b>Uso de campo com barreira máxima</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de campo com barreira máxima</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_sterile_gel']){
                    echo $checked_img.'<b>Uso de gel estéril de xilocaína ou similar</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de gel estéril de xilocaína ou similar</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['suitable_catheter_progression']){
                    echo $checked_img.'<b>Progressão adequada do cateter</b>';
                  }else{
                    echo $not_checked_img.'<b>Progressão adequada do cateter</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['urine_output_cauterization']){
                    echo $checked_img.'<b>Saída de urina de imediato após cateterização</b>';
                  }else{
                    echo $not_checked_img.'<b>Saída de urina de imediato após cateterização</b>';
                  }
                echo '</div>';    


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['adequate_catheter_fixation']){
                    echo $checked_img.'<b>Fixação adequada do cateter</b>';
                  }else{
                    echo $not_checked_img.'<b>Fixação adequada do cateter</b>';
                  }
                echo '</div>';  


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['confirmation_of_position_with_us']){
                    echo $checked_img.'<b>Posição confimada com ultrassom</b>';
                  }else{
                    echo $not_checked_img.'<b>Posição confimada com ultrassom</b>';
                  }
                echo '</div>';  

               
                echo '<div class="col-sm-12">';
                   echo $this->Form->input('checklist_observation', [ 'type'=>'textarea', 'label'=>['text'=>'Observação do Checklist:', 'class'=>'form-input'] ]);
                echo '</div>';  

            echo '</div>';



            echo "<div class='col-md-12 no-padding'>";
                
                echo "<br><legend class='big-title'>Descrição orientada:</legend>";


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Número de tentativas:</b>'.$ituPreventionBundle['number_of_retries'];
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Número de Profissionais insertadores:</b>'.$ituPreventionBundle['number_of_professionals'];
                echo '</div>';



                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['blood_on_catheter']){
                    echo $checked_img.'<b>Presença de sangue no sistema coletor</b>';
                  }else{
                    echo $not_checked_img.'<b>Presença de sangue no sistema coletor</b>';
                  }
                echo '</div>';  

                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['successful_integration']){
                    echo $checked_img.'<b>Sucesso na inserção</b>';
                  }else{
                    echo $not_checked_img.'<b>Sucesso na inserção</b>';
                  }
                echo '</div>';


                $c='';

                foreach ($ituPreventionBundle['immediate_complications'] as $key => $complication) {
                       $c.= $complication['nome'].',';
                }

                $c = trim($c,",");
                
                echo'
                <div class="col-sm-12">
                <div class="form-group textarea">

                 <label class="form-input" for="immediate-complications">Complicações imediatas:</label>

                 <textarea name="immediate_complications" maxlength="11" id="immediate-complications" class="form-control" rows="3" readonly="">'.$c.'</textarea>

                </div></div>';

            echo '</div>';




            echo "<div class='col-md-12 no-padding'>";
                
                echo "<br><legend class='big-title'>Retirada do CVD ou citostomia:</legend>";


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Data de Retirada:</b>'.$ituPreventionBundle['date_of_withdrawal'];
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Hora de Retirada:</b>'.$ituPreventionBundle['withdrawal_time'];
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['accidental_removal']){
                    echo $checked_img.'<b>Retirada acidental</b>';
                  }else{
                    echo $not_checked_img.'<b>Retirada acidental</b>';
                  }
                echo '</div>';

                echo '<div class="col-sm-12 print">';
                    echo '<div class="funkyradio accidental_removal">';
                        echo $this->Form->input('motive_accidental_removal', [ 'type'=>'textarea', 'label'=>['text'=>'Motivo da retirada acidental:', 'class'=>'form-input'] ]);
                    echo "</div>";
                echo "</div>";

            echo "</div>"; 



        ?>
</div>

<script>
(function(){
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    // $('#footer').addClass('print');
    console.log($('#footer'));
    $('nav').css('display','none');
    window.print();
    setTimeout(function () { window.close(); },300);

})();
</script>
