
<div class="patients form col-md-10 columns content">
    <?= $this->Form->create($patient) ?>
    <fieldset>
        <legend><h3 class="big-title"><?= h($patient->nome) ?></h3></legend>
        <?php
            
            $dateFromDb = $patient->birthday->format('d-m-Y');
            $convenio_opt = [];
            $convenio_opt['Particular'] =  "Particular";

            if (isset($health_insurance_plans[0])) {
                foreach ($health_insurance_plans as $key => $value) {                    
                    $convenio_opt[$value['name']] = $value['name'];
                }                
            }

            $sexo=['Masculino'=>'Masculino', 'Feminino'=>'Feminino'];
            // $convenio_opt['Particular'] =  "Particular";
            $raça_opt = ['Branca'=>'Branca','Preta'=>'Preta', 'Amarela'=>'Amarela','Parda'=>'Parda','Indígena'=>'Indígena'];
            $estadoCivil_opt = ['Solteiro(a)'=>'Solteiro(a)', 'Casado(a)'=>'Casado(a)', 'Separado(a)'=>'Separado(a)',  'Divorciado(a)'=>'Divorciado(a)', 'Viúvo(a)'=>'Viúvo(a)',  'União Estável'=>'União Estável'];



            echo "<div class='row'>";                
                echo "<div class='col-md-4'>";
                    echo '<p class="mandatory-message">Os campos com * são obrigatórios.</p><br>';
                                
                    echo '<div id="cpf-validate" class="form-group text required"><label class="form-input mandatory" for="document-number">CPF:</label><input value="'.$patient->document_number.'" type="text" name="document_number" required="required" maxlength="20" id="document-number" class="form-control">  <span class="help-block" style="display:none">CPF inválido</span></div>';
                    echo '<span style="display:none" id="cpf_status">CPF Válido</span>';
                echo "</div>";
                echo "<div class='col-md-8'>";  
                echo '<p class="mandatory-message">&nbsp;</p><br>';
                    echo $this->Form->input('nome', ['label'=>['text'=>'Nome:', 'class'=>'form-input']]);
                echo "</div>";
            echo "</div>";

            

            echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('cellphone_number', ['type'=>'text','label'=>['text'=>'Celular:', 'class'=>'form-input']]);
                    
                echo "</div>";

                echo "<div class='col-md-6'>";
                    echo $this->Form->input('email', ['label'=>['text'=>'E-mail:', 'class'=>'form-input']]);        
                echo "</div>";
            echo "</div>";

             echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                     echo $this->Form->input('sexo', ['label'=>['text'=>'Sexo:', 'class'=>'form-input mandatory'], 'options'=>$sexo]);
                echo "</div>";
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('birthday', ['type'=>'text','label'=>['text'=>'Data de Nascimento:', 'class'=>'form-input'],'empty' => true, 'default' => '', 'value'=>$dateFromDb]);
                echo "</div>";
            echo "</div>";
                
             echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('nationality', ['class'=>'nacionalidades', 'label'=>['text'=>'País de Origem:', 'class'=>'form-input']]);
                echo "</div>";
                echo "<div class='col-md-6'>";
                   echo $this->Form->input('profession', ['label'=>['text'=>'Profissão:', 'class'=>'form-input']]);
                echo "</div>";
            echo "</div>";
            
            echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('civil_status', ['label'=>['text'=>'Estado Civil:', 'class'=>'form-input'], 'options'=>$estadoCivil_opt]);
                echo "</div>";
                echo "<div class='col-md-6'>";
                   echo $this->Form->input('race', ['label'=>['text'=>'Raça:', 'class'=>'form-input'], 'options'=>$raça_opt]);
                echo "</div>";
            echo "</div>";

            echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('father_name', ['label'=>['text'=>'Nome do Pai:', 'class'=>'form-input']]);
                    echo $this->Form->hidden('medical_record_number');
                echo "</div>";
                echo "<div class='col-md-6'>";
                   echo $this->Form->input('mother_name', ['label'=>['text'=>'Nome da Mãe:', 'class'=>'form-input']]);
                echo "</div>";
            echo "</div>";

            echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('responsible_name', ['label'=>['text'=>'Nome do Responsável:', 'class'=>'form-input']]);
                echo "</div>";
                echo "<div class='col-md-6'>";
                   echo $this->Form->input('religion', ['label'=>['text'=>'Religião:', 'class'=>'form-input']]);
                echo "</div>";
            echo "</div>";

            echo "<div class='row'>";                
                echo "<div class='col-md-6'>";
                    echo $this->Form->input('medical_care', ['label'=>['text'=>'Convênio:', 'class'=>'form-input'], 'options'=>$convenio_opt]);
                echo "</div>";
                echo "<div class='col-md-6'>";
                   echo $this->Form->hidden('is_active', ['value'=>1]);
                   echo $this->Form->input('phone_number', ['type'=>'text','label'=>['text'=>'Telefone:', 'class'=>'form-input']]);
                echo "</div>";
            echo "</div>";
            
            
            
            
            

            
            
            
            
            
            
            
            
            


            echo "<br><br><div class='row'>";
                echo "<legend class='big-title'>&nbsp;&nbsp;&nbsp;Endereço</legend>";
                echo "<div class='col-md-2'>";
                    echo $this->Form->input('cep', ['label'=>['text'=>'CEP:', 'class'=>'form-input mandatory', 'id'=>'cep-label']]);   
                echo "</div>";

                echo "<div class='col-md-3'>";
                    echo '<div style="margin: 0 auto;"><a  target="_blank" href="http://www.buscacep.correios.com.br/sistemas/buscacep/"> <button type="button" class="btn btn-gray consultar-cep">Não sei meu CEP</button></a></div>';
                echo "</div>";

                echo "<div class='col-md-4'>";
                    echo $this->Form->input('logradouro', ['label'=>['text'=>'Logradouro:', 'class'=>'form-input']]);
                echo "</div>";

                echo "<div class='col-md-3'>";
                    echo $this->Form->input('address_number', ['label'=>['text'=>'Número:', 'class'=>'form-input ']]);
                echo "</div>"; 

                echo "<div class='col-md-4'>";
                    echo $this->Form->input('bairro', ['label'=>['text'=>'Bairro:', 'class'=>'form-input']]);     
                echo "</div>"; 

                echo "<div class='col-md-4'>";
                    echo $this->Form->input('city', ['label'=>['text'=>'Cidade:', 'class'=>'form-input mandatory']]); 
                echo "</div>"; 

                echo "<div class='col-md-4'>";
                    echo $this->Form->input('country', ['class'=>'nacionalidades', 'label'=>['text'=>'País:', 'class'=>'form-input mandatory']]);
                echo "</div>"; 
            echo "</div>";


        ?>
    </fieldset>
    <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
    <?= $this->Form->button(__('Salvar')) ?>
    <?= $this->Form->end() ?>

    <p></p>
    <p></p>
    <br><br>
    <p></p>
    <p></p>
</div>


<script >

$(document).ready( function() {

    console.log( "ready!" );
    $("#cpf_status").html(CPF.valida($(this).val()));
    console.log(CPF.valida($(this).val()));

    $( ".nacionalidades" ).autocomplete({
      source: nacionalidades
    });

    /* Executa a requisição quando o campo CEP perder o foco */
    $('#cep').blur(function(){
        var cep = $('#cep').val().replace(/\.|\-/g, ''); 

       /* Configura a requisição AJAX */
        $.ajax({
          url: 'http://correiosapi.apphb.com/cep/'+cep,
          dataType: 'jsonp',
          crossDomain: true,
          contentType: "application/json",
          statusCode: {
            200: function(data) { 
                console.log(data); 
                
                $('#logradouro').val(data.logradouro);
                $('#bairro').val(data.bairro);
                $('#city').val(data.cidade);
                $('#country').val('Brasil');
                $('#cep-label').text("CEP:")
            } // Ok

            ,400: function(msg) {
                console.log("log1");
                console.log(msg);  
                $('#cep-label').text("CEP:  Não encontrado!")
             } // Bad Request

            ,404: function(msg) { 
                console.log("log2");
                console.log("CEP não encontrado!!");
                $('#cep-label').text("CEP:  Não encontrado!")
             } // Not Found
          }
        })

        return false;  
    });
});

$("#document-number").bind("keyup change", function(e) {

    if ( $("#document-number").val()=='' || $("#document-number").val()==null ){
        $("#cpf-validate span").hide();
        $("#cpf-validate").removeClass( "has-error has-feedback" );
    }

    if (CPF.valida($(this).val()) == "CPF Válido")
    {
        console.log("yoo2");
        $("#cpf-validate").removeClass( "has-error has-feedback" );
        $("#cpf-validate").addClass( "has-success" );
        $("#cpf-validate span").hide();
    }
    else
    {
        console.log('yoo.');
        $("#cpf-validate").addClass( "has-error has-feedback" );
        $("#cpf-validate span").show();
    }
});

var nacionalidades = ["Brasil", "Afeganistão","África do Sul","Albânia","Alemanha","Angola","Arábia Saudita","Argélia","Argentina","Arménia","Austrália","Áustria","Azerbajão","Bahrein","Bélgica","Belize","Benin","Bielorrússia","Blangadesh","Bolívia","Bósnia-e-Herzegovina","Botswana","Brunei","Bulgária","Burkina Faso","Burundi","Butão","Cabo Verde","Camarões","Camboja","Canadá","Catar","Cazaquistão","Centro-África (Replublica)","Chade","Checa (República)","Chile","China","Chipre","Colômbia","Comores","Congo (República  Democrática do)","Congo (República do)","Coreia (República Popular Democrática da)","Coreia do Norte","Coreia do Sul","Costa do Marfim","Costa Rica","Croácia","Cuba","Dinamarca","Djibouti","Djidouti","Egipto","El Salvador","Emirados Árabes Unidos","Equador","Eriteia","Escócia","Eslováquia","Eslovénia","Espanha","Estados Unidos da América","Estónia","Etiópia","Filipinas","Finlândia","França","Gabão","Gâmbia","Gana","Geórgia","Grécia","Gronelândia","Guatemala","Guiana Francesa","Guiné","Guiné Bissau","Guiné Equatorial","Guiné-Bissau","Haiti","Honduras","Hong Kong","Hungria","Huwait","Iémen","Índia","Indonésia","Irão","Irão (República Islâmica do)","Iraque","Irlanda","Islândia","Israel","Itália","Japão","Jordânia","Jugoslávia","Kosovo","Kuwait","Laos","Lesoto","Letónia","Líbano","Libéria","Líbia","Líbia (Jamahiriya Árabe da)","Liechtenstein","Lituânia","Luxemburgo","Macau","Macedônia","Madagáscar","Malásia","Malawi","Maldivas","Mali","Malta","Marrocos","Maurícia","Mauritânia","México","Moçambique","Moldávia","Mônaco (Principado de)","Mongólia","Montenegro","Myanmar","Namíbia","Naníbia","Nepal","Nicarágua","Níger","Nigéria","Noruega","Nova Zelândia","Omã","Países Baixos","Palestina","Panamá","Paquistão","Paraguai","Peru","Polónia","Portugal","Quénia","Quênia","Quirquistão","Regiões polares","Reino Unido","República Dominicana","Roménia","Ruanda","Rússia (Federação da)","Saara Ocidental","São Tomé e Príncipe","Seicheles","Senegal","Serra Leoa","Sérvia","Singapura","Siri Lanka","Síria","Síria (República Árabe da)","Somália","Suazilândia","Sudão","Sudão do Sul","Suécia","Suíça","Tailândia","Taiwan","Tajiquistão","Tanzânia","Timor Leste","Togo","Tunísia","Turquemenistão","Turquia","Ucrânia","Uganda","Uruguai","Uzbequistão","Venezuela","Vietnã","Zâmbia","Zimbabwe","Outros países Africanos","Outros países Americanos","Outros países Asiáticos","Outros países da Oceania","Outros países Europeus","Países e territórios ignorados"];




(function() {
   // your page initialization code here
   // the DOM will be available here

   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)', 
    array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Editar Paciente</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>