<div class="row">

   <?php
     echo $this->Html->script('prescription-forms-scripts.js');

     if ($current_state == 'internacao') {
         echo $this->element('internacao-menu');
     }
     else {
         echo $this->element('screening-menu');
     }

     if (!isset($numberOfMedications)) {
         $numberOfMedications = 0;
     }

     $via = [
       'CNG' => 'CNG',
       'Enteral' => 'Enteral',
       'GTT' => 'GTT',
       'IM' => 'IM',
       'IV' => 'IV',
       'Nasal' => 'Nasal',
       'NBZ' => 'NBZ',
       'Ocular' => 'Ocular',
       'Oral' => 'Oral',
       'Retal' => 'Retal',
       'SC'=> 'SC',
       'Spray' => 'Spray',
       'Tópico' => 'Tópico',
       'Tecal' => 'Tecal',
       'Intrauricular' => 'Intrauricular',
       'Intracavitária' => 'Intracavitária',
       'NSA' => 'NSA'
     ];

     $frequencies =  [
          '1X SEM' => '1X SEM',
          'SEG QUA SEX' => 'SEG QUA SEX',
          'TER QUI SAB' => 'TER QUI SAB',
          'DIAS ALTERNADOS' => 'DIAS ALTERNADOS',
          '1X DIA' => '1X DIA',
          '12/12 H' => '12/12 H',
          '8/8 H' => '8/8 H',
          '6/6 H' => '6/6 H',
          '4/4 H' => '4/4 H',
          '3/3 H' => '3/3 H',
          '2/2 H' => '2/2 H',
          '1/1 H' =>'1/1 H',
          'ACM' => 'ACM',
          'SOS' => 'SOS',
          'BI' => 'BI',
          'NSA' => 'NSA',
     ];

   ?>


   <div  class="prescriptions form col-md-9 columns content">
      <?=$this->Form->create($prescription, ['id' => 'prescription-form'])?>
      <?= $this->Form->hidden('professional_id',['value' => $professional['id']]);?>

           <?php

               if ($current_state == "internacao")
               {
                   echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);
               }
               else
               {
                   echo $this->Form->hidden('screening_id', ['value' => $screening_id]);
               }

               echo $this->Form->hidden('sector_id',['value' => $currentSector['id']]);

               echo $this->Form->input('name', ['class' => 'medication-name', 'required' => true, 'empty' => true, 'label' => ['text' => 'Nome da prescrição:', 'class' => 'form-input']]);

               echo $this->Form->input('avaiable_sectors._ids', ['options'=> $sectors,'class'=>'multiselect','label'=>['text'=>'Setor(es) a ser disponibilizado(s):','class'=>'form-input '],'type' => 'select', 'multiple' => true]);

            ?>
           <div>
             <p class="info-text"><i class="glyphicon glyphicon-info-sign"></i>Arraste os itens para organiza-los se necessário.</p>
              <table class="table table-striped table-hover" id="default-prescription-table">

                  <thead>
                      <tr>
                          <th>Medicamento / Procedimento</th>
                          <th>Quantidade</th>
                          <th>Via de Administração</th>
                          <th>Frequência</th>
                          <th class="actions"><?=__('Ações')?></th>
                      </tr>
                  </thead>

                  <tbody id='tbody'>

                  </tbody>

              </table>
              <button type="button" class="btn btn-add-item btn-success" onclick="appendItem('defaultPrescriptionsForm')"><i class="glyphicon glyphicon-plus"></i></button>
           </div>
           <div class="action-buttons-div">
              <button type="button" class="btn btn-add-item-responsive btn-success" onclick="appendItem('defaultPrescriptionsForm')"><i class="glyphicon glyphicon-plus"></i></button>
              <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
             <?=$this->Form->button(__('Salvar'), ['class'=>' btn btn-success'])?>
           </div>

      <?=$this->Form->end()?>
   </div>

</div>

<script>

  $(document).ready(function() {

    var numberOfMedications  = <?= (isset($numberOfMedications)) ? $numberOfMedications : 0 ?>;
    var systemMedications    = <?= (isset($systemMedications)) ? json_encode($systemMedications): json_encode([]) ?>;

    initializeMedicationsCounter(numberOfMedications);
    initializeSystemMedicationsObj(systemMedications);

  });

  <?php if ($current_state == "internacao"): ?>

          (function() {

             var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

             var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

             var link3 =' <?=$this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var html = '';
                  html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                  html+= link1;
                  html+= link2;
                  html+= link3;
                  html+= link4;
                  html+= '<a href="#" class="breadcumb-active btn btn-default">Nova Prescrição padrão</a>';
                  html+= '</div>';
                      document.getElementById("breadcumb").innerHTML =html;
          })();

  <?php else: ?>

          (function() {

             var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
             ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

             var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

             var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'hospitalizations', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var html = '';
                  html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                  html+= link1;
                  html+= link2;
                  html+= link3;
                  html+= link4;
                  html+= '<a href="#" class="breadcumb-active btn btn-default">Nova Prescrição padrão</a>';
                  html+= '</div>';
                      document.getElementById("breadcumb").innerHTML =html;
          })();


  <?php endif;?>

</script>
