<div class="row">

<?php

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $prescriptionTypes = [
      'Sepse',
      'Pós Operatório-Bariátrica',
      'Pós Operatório-Cardíaca',
      'Insuficiência Cardíaca',
      'IAM'
   ];
?>

<div class="medications index col-md-9 columns content">

   <div class="patient-info">
      <h4>Nome do paciente: Gabriella</h4>
      <h4>Idade: 17</h4>
      <h4>Prontuário:123</h4>
   </div>

   <div class="btn-group prescriptions-types">

      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
           Selecionar Prescrição Padrão
           <span class="caret"></span>
       </button>
       <ul class="dropdown-menu">
          <?php foreach ($default_prescriptions as $key => $dp): ?>
            <li>
                <?=$this->Html->link($dp->name, ['controller' => 'prescriptions', 'action' => 'includeDefaultPrescriptions',$dp->id, '_full' => true]);?>
            </li>
          <?php endforeach; ?>

       </ul>

   </div>
   <?= $this->Form->create('index', ['type'=>'post','id' => 'item-selection-form']) ?>
      <table class="table table-striped table-hover">
           <thead>
               <tr>
                   <th><?= $this->Form->checkbox('', ['label' => false, 'id' =>'select-all']); ?></th>
                   <th><?= $this->Paginator->sort('name', 'Medicamento/ Procedimento / Exame') ?></th>
                   <th><?= $this->Paginator->sort('Quantidade') ?></th>
                   <th><?= $this->Paginator->sort('Via de administração') ?></th>
                   <th><?= $this->Paginator->sort('Frequência') ?></th>
               </tr>
           </thead>
           <tbody>
               <?php if($prescription): ?>
                  <?php foreach ($prescription['prescription_medications'] as $medication): ?>
                     <tr>
                        <td><?= $this->Form->checkbox($medication->id, ['class'=>'medication-check','label' => false, 'value' => $medication->id]); ?></td>
                         <td><?= $medication->system_medication['name'] ?></td>
                         <td><?= $medication->quantity ?></td>
                         <td><?= $medication->channel ?></td>
                         <td><?= $medication->frequency ?></td>
                     </tr>
                  <?php endforeach; ?>
               <?php endif; ?>
           </tbody>
       </table>
       <div style="display:none;">

       </div>
       <div class="action-buttons-div">
         <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
         <?=$this->Form->button(__('Incluir'), ['class'=>' btn btn-success'])?>
       </div>
    <?= $this->Form->end() ?>
</div>
</div>

<script>

      $("#select-all").click(function() {
         $(".medication-check").prop('checked',$(this).prop('checked'));
      });


      $("#item-selection-form").on("submit",function() {
         var anyChecked = false;

         $(".medication-check").each(function() {
            if ($(this).prop('checked')) {
               anyChecked = true;
            }
         });

         if(anyChecked) {
            return true;
         }
         $.alert({
             title: 'Aviso!',
             confirmButton: 'Ok',
             content: 'Selecione ao menos um item para inclusão.',
         });
         return false;
      });



      <?php if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here
               var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',[
                  'controller' => 'Users', 'action' => 'login'],
                  ['class' => 'btn btn-default ', 'escape' => false
               ])?> ';

               var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição Padrão</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();
      <?php else: ?>

              (function() {
                 // your page initialization code here
                 // the DOM will be available here
                  var link1 =' <?=$this->Html->link(
              '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
          ['controller' => 'Users', 'action' => 'login'],
              ['class' => 'btn btn-default ', 'escape' => false]
          )?> ';

                  var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var html = '';
                      html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                      html+= link1;
                      html+= link2;
                      html+= link3;
                      html+= '<a href="#" class="breadcumb-active btn btn-default">Prescrição Padrão</a>';
                      html+= '</div>';
                          document.getElementById("breadcumb").innerHTML =html;
              })();
      <?php endif;?>

   </script>
