<div class="row">

<?php
   echo $this->Html->script('prescription-forms-scripts.js');

   if ($current_state == 'internacao') {
       echo $this->element('internacao-menu');
   } else {
       echo $this->element('screening-menu');
   }

   $prescriptionTypes = [
      'Sepse',
      'Pós Operatório-Bariátrica',
      'Pós Operatório-Cardíaca',
      'Insuficiência Cardíaca',
      'IAM'
   ];

   $surveillanceSignalings = [
      'Alta Vigilância' => 'Alta Vigilância',
      'Med. Potencialmente Perigosas' => 'Med. Potencialmente Perigosas',
      'Não Padronizada' => 'Não Padronizada'
   ];

    $from = $selected_patient_birthday;
    $to = new DateTime('today');
    $age = $from->diff($to)->y;

?>

<div class="medications index col-md-9 columns content">
   <div class="patient-info">
      <div class="patient-info">
        <h4>Nome do paciente: <?= $patient_name; ?> </h4>
        <h4>Setor: <?= $hospitalization->sectorName($hospitalization['id']); ?></h4>

      </div>
      <div class="patient-info">
        <h4>Idade: <?= $age ?></h4>
        <h4>Prontuário: <?= $hospitalization->numero_do_prontuario; ?></h4>
      </div>
   </div>
   <?= $this->Form->create('index', ['type'=>'post','id' => 'item-selection-form']) ?>
      <?php $this->Form->templates(['inputContainer' => '{{content}}']); ?>
      <table class="table table-striped table-hover">
           <thead>
               <tr>
                   <!-- <th><?= $this->Form->checkbox('all', ['label' => false, 'id' =>'select-all']); ?></th> -->
                   <th><?= $this->Paginator->sort('name', 'Medicamento/ Procedimento / Exame') ?></th>
                   <th><?= $this->Paginator->sort('Quantidade') ?></th>
                   <th><?= $this->Paginator->sort('Via de administração') ?></th>
                   <th><?= $this->Paginator->sort('Frequência') ?></th>
                   <th><?= $this->Paginator->sort('Sinalização farmacêutica') ?></th>
                   <th><?= $this->Paginator->sort('Observação') ?></th>
               </tr>
           </thead>
           <tbody>
               <?php if($prescription): ?>
                  <?php foreach ($prescription['prescription_medications'] as $key => $medication): ?>
                     <tr class="input-row ">
                        <!-- <td><?= $this->Form->checkbox($medication->id, ['class'=>'medication-check','label' => false, 'value' => $medication->id]); ?></td> -->
                         <td>
                           <?= $this->Form->hidden('prescription_medications.'.$key.'.id', ['label' => false, 'value' => $medication->id]); ?>
                           <?= $medication->system_medication['name'] ?>
                         </td>
                         <td><?= $medication->quantity ?></td>
                         <td><?= $medication->channel ?></td>
                         <td><?= $medication->frequency ?></td>
                         <td class="input-tds">
                           <?=
                              $this->Form->input('prescription_medications.'.$key.'.surveillance_signaling', ['options'=> $surveillanceSignalings,'value' => $medication->surveillance_signaling, 'empty'=>true ,'required'=>true,'label' => false]);
                           ?>
                         </td>
                         <td class="observation-td">
                           <span class="insert-observation glyphicon glyphicon-info-sign" data-toggle="modal" data-target="#medication-modal-<?=$key?>"></span>
                           <?= $this->Form->hidden('prescription_medications.'.$key.'.observation', ['label' => false, 'value' => $medication->observation,'id'=>'prescription-medications-'.$key.'-observation']); ?>
                         </td>
                     </tr>
                  <?php endforeach; ?>
               <?php endif; ?>
           </tbody>
       </table>

       <div class="medication-modals">
       </div>

       <div class="action-buttons-div">
         <button type="button" onclick="goBack()" class="btn btn-danger" >Cancelar</button>
         <?=$this->Form->button(__('Validar'), ['class'=>' btn btn-success'])?>
       </div>

    <?= $this->Form->end() ?>
</div>
</div>

<script>

      $(document).ready(function() {

          var numberOfMedications  = <?= (!empty($prescription['prescription_medications']))
          ? count($prescription['prescription_medications'])
          : 0 ?>;

          initializeMedicationsCounter(numberOfMedications);

          setTimeout(function() {
            if (numberOfMedications>0) {
              var i = 0;
              while (i < numberOfMedications) {
                var lastMedicationObservation = $('#prescription-medications-'+i+'-observation').val();
                $(".medication-modals").append(getValidationModal(i));
                $('#medication-modal-'+i).find('textarea').val(lastMedicationObservation);
                i++;
              }
            }
          },2000);

      });

      $("#select-all").click(function() {
         $(".medication-check").prop('checked',$(this).prop('checked'));
      });

      // $("#item-selection-form").on("submit",function() {
      //    var anyChecked = false;
      //
      //    $(".medication-check").each(function() {
      //       if ($(this).prop('checked')) {
      //          anyChecked = true;
      //       }
      //    });
      //
      //    if(anyChecked) {
      //       return true;
      //    }
      //    $.alert({
      //        title: 'Aviso!',
      //        confirmButton: 'Ok',
      //        content: 'Selecione ao menos um item para validação.',
      //    });
      //    return false;
      // });



      <?php if ($current_state == "internacao"): ?>
           (function() {
              // your page initialization code here
              // the DOM will be available here
               var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',[
                  'controller' => 'Users', 'action' => 'login'],
                  ['class' => 'btn btn-default ', 'escape' => false
               ])?> ';

               var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

               var html = '';
                   html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                   html+= link1;
                   html+= link2;
                   html+= link3;
                   html+= '<a href="#" class="breadcumb-active btn btn-default">Validação de itens</a>';
                   html+= '</div>';
                       document.getElementById("breadcumb").innerHTML =html;
           })();
      <?php else: ?>

              (function() {
                 // your page initialization code here
                 // the DOM will be available here
                  var link1 =' <?=$this->Html->link(
              '<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
          ['controller' => 'Users', 'action' => 'login'],
              ['class' => 'btn btn-default ', 'escape' => false]
          )?> ';

                  var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

                  var html = '';
                      html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                      html+= link1;
                      html+= link2;
                      html+= link3;
                      html+= '<a href="#" class="breadcumb-active btn btn-default">Validação de itens</a>';
                      html+= '</div>';
                          document.getElementById("breadcumb").innerHTML =html;
              })();
      <?php endif;?>

   </script>
