<div class="row">
<?php

if ($current_state == 'internacao') {
    echo $this->element('internacao-menu');
} else {
    echo $this->element('screening-menu');
}

?>
<div class="medications index col-md-9 columns content">
   <?= $this->Form->create('index', ['type'=>'get','class'=>'search-form']) ?>
         <div class="inline-items search-block">
              <?php

                 echo $this->Form->input('q_type', [
                    'label'=> 'Buscar por',
                    'empty' => true,
                    'options'=> ['name'=>'Nome','date'=>'Data','sector'=>'Setor'],
                    'templates' => [
                       'inputContainer' => '<div class="inline-filter {{type}}{{required}}">{{content}}</div>'
                    ],
                 ]);

                 echo $this->Form->input('q', [
                    'id'=>'query-field',
                    'label'=>false,
                    'placeholder'=>'Digite aqui sua busca',
                    'templates' => [
                       'inputContainer' => '<div class="search-field-div form-group {{type}}{{required}}">{{content}}</div>'
                    ],
                 ]);
              ?>
            <?= $this->Form->button('Pesquisar', ['class'=>'search-button']) ?>
         </div>
   <?= $this->Form->end() ?>

   <div class="print-button-div">
      <h4>Resultado de busca</h4>
   </div>

   <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('name','Nome') ?></th>
                <th><?= $this->Paginator->sort('Setor') ?></th>
                <th><?= $this->Paginator->sort('Data') ?></th>
                <th><?= $this->Paginator->sort('Validação farmacêutica') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($prescriptions as $prescription): ?>
            <tr>
                <td><?= $prescription->name ?></td>
                <td><?= $prescription->sector['name'];?></td>
                <td><?= $prescription->created->format("d/m/Y") ?> </td>
                <td><?= ($prescription->validated) ? '<span class="green-lbl">Sim</span>' : '<span class="red-lbl">Não</span>'; ?></td>

                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('Visualizar'), ['action' => 'pharmaceuticalItemsValidation', $prescription->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?php if (!$prescription->validated): ?>
                       <?= $this->Form->postLink(__('Validar'), ['action' => 'validatePrescription', $prescription->id], [
                         'confirm' => __('Tem certeza que deseja validar toda a prescrição ?'),
                         'class'=>'btn btn-green btn-xs']) ?>
                    <?php else: ?>
                       <?= $this->Form->postLink(__('Invalidar'), ['action' => 'invalidatePrescription', $prescription->id], [
                         'confirm' => __('Tem certeza que deseja invalidar toda a prescrição ?'),
                         'class'=>'btn btn-danger btn-xs']) ?>
                    <?php endif; ?>
                </td>

            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <!-- <div class="paginator">
     <center>
         <ul class="pagination">
             <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
             <?= $this->Paginator->numbers(['escape'=>false]) ?>
             <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
         </ul>
         <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
      {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
      </center>
    </div> -->

</div>
</div>


<script>

    $('.search-form').on('submit',function() {

      var firstCase  = ($("#query-field").val() != '' && $("#q-type").val() == '');
      var secondCase = ($("#query-field").val() == '' && $("#q-type").val() != '');

      if(firstCase) {
        $("#q-type").attr('required', true);
        return false;
      }
      else if(secondCase) {
        $("#query-field").attr('required', true);
        return false;
      }
      else {
          $("#q-type").removeAttr('required');
          $("#query-field").removeAttr('required');
          return true;
      }

    });

    $("#q-type").change(function() {

      if($(this).val() === 'date') {
        $("#query-field").val('');
        $("#query-field").addClass('date');
      }
      else {
        $("#query-field").removeClass('date');
        $('#query-field').unmask();
        if($('#query-field').data('datepicker') != undefined) {
          $('#query-field').data('datepicker').remove();
        }
      }

    });

  <?php

    if ($current_state == "internacao"): ?>

            (function() {
               // your page initialization code here
               // the DOM will be available here
                var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'],
                 ['class' => 'btn btn-default ', 'escape' => false])?> ';

                var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

                var link3 =' <?=$this->Html->link('Internações', ['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

                var html = '';
                    html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                    html+= link1;
                    html+= link2;
                    html+= link3;
                    html+= '<a href="#" class="breadcumb-active btn btn-default">Validação</a>';
                    html+= '</div>';
                        document.getElementById("breadcumb").innerHTML =html;
            })();

  <?php else: ?>

          (function() {
             // your page initialization code here
             // the DOM will be available here
              var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',['controller' => 'Users', 'action' => 'login'],
              ['class' => 'btn btn-default ', 'escape' => false])?> ';

              var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

              var html = '';
                  html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                  html+= link1;
                  html+= link2;
                  html+= link3;
                  html+= '<a href="#" class="breadcumb-active btn btn-default">Validação</a>';
                  html+= '</div>';
                      document.getElementById("breadcumb").innerHTML =html;
          })();

  <?php endif;?>

</script>
