<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
    </head>
    <body>
        <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Escores'] ); ?>   
        <div class="container">

            <!-- Pre Deliric START -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">            
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=2 >  Pré Deliric  </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['pre_deliric']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['pre_deliric']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['pre_deliric']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['pre_deliric']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td> <?= $data['pre_deliric']['escore']['desvio_padrao'] ?> </td>
                        <td>0</td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 40%</td>
                        <td> <?= $data['pre_deliric']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com valor superior a 40%</td>
                        <td> <?= $data['pre_deliric']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                    
                </tbody>
            </table>
            <!-- Pre Deliric END -->

            <!-- Sofa START -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">            
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">    
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=2 >  Sofa  </td>
                    </tr>                 
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['sofa']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['sofa']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td> <?= $data['sofa']['escore']['mediana'] ?> </td>
                        <td> 0</td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['sofa']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['sofa']['escore']['desvio_padrao'] ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com aumento maior/igual a dois pontos durante a internação</td>
                        <td>0</td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com aumento maior/igual a dois pontos durante a internação</td>
                        <td>0</td>
                    </tr>
                </tbody>
            </table>
            <!-- Sofa END -->

            <!-- Curb START -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse; page-break-after: always;">            
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=2 >  Curb 65  </td>
                    </tr>   
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['curb']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['curb']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['curb']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['curb']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['curb']['escore']['desvio_padrao'] ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 2</td>
                        <td> <?= $data['curb']['total_superior_2'] ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 3</td>
                        <td> <?= $data['curb']['total_superior_3'] ?> </td>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 4</td>
                        <td> <?= $data['curb']['total_superior_4'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Curb END -->


            <!-- Apache START -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">            
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">                                        
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=2>  Apache II </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['apache']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['apache']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['apache']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['apache']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['apache']['escore']['desvio_padrao'] ?> </td>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 40%</td>
                        <td> <?= $data['apache']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com valor superior a 40%</td>
                        <td> <?= $data['apache']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Apache II END -->

            <!-- Crib Start -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">            
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">  
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=2 >  CRIB  </td>
                    </tr>               
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['crib']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['crib']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['crib']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['crib']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['crib']['escore']['desvio_padrao'] ?> </td>
                    </tr>

                    <tr >
                        <td>Previsão de óbito mínima</td>
                        <td> 0 </td>
                    </tr>
                    <tr >
                        <td>Previsão de óbito máxima</td>
                        <td> 0 </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão da previsão de óbito</td>
                        <td> <?= $data['crib']['escore']['desvio_padrao'] ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana da previsão de óbito</td>
                        <td> <?= $data['crib']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média da previsão de óbito</td>
                        <td> <?= $data['crib']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão da previsão de óbito</td>
                        <td> <?= $data['crib']['escore']['desvio_padrao'] ?> </td>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 40%</td>
                        <td> <?= $data['crib']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com valor superior a 40%</td>
                        <td> <?= $data['crib']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>
                </tbody>
            </table>
            <!-- Crib END -->

            <!-- SNAP II Start -->
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">            
                <thead>

                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Total</th>                      
                    </tr>
                </thead>      
                    
                <tbody class="yolo">    
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=2 >  SNAP II  </td>
                    </tr>                   
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <td> <?= $data['snap']['total_pacientes'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com escore preenchido</td>
                        <td> <?= number_format($data['snap']['percentual_pacientes'], 2) ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <td> <?= $data['snap']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <td> <?= $data['snap']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <td> <?= $data['snap']['escore']['desvio_padrao'] ?> </td>
                    </tr>

                    <tr >
                        <td>Previsão de óbito mínima</td>
                        <td> 0 </td>
                    </tr>
                    <tr >
                        <td>Previsão de óbito máxima</td>
                        <td> 0 </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão da previsão de óbito</td>
                        <td> <?= $data['snap']['escore']['desvio_padrao'] ?> </td>
                    </tr>
                    <tr >
                        <td>Mediana da previsão de óbito</td>
                        <td> <?= $data['snap']['escore']['mediana'] ?> </td>
                    </tr>
                    <tr >
                        <td>Média da previsão de óbito</td>
                        <td> <?= $data['snap']['escore']['media'] ?> </td>
                    </tr>
                    <tr >
                        <td>Desvio padrão da previsão de óbito</td>
                        <td> <?= $data['snap']['escore']['desvio_padrao'] ?> </td>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 70 pontos ou previsão de óbito superior a 40%</td>
                        <td> <?= $data['snap']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                    </tr>
                    <tr >
                        <td>Percentual de pacientes com valor superior a 70 pontos ou previsão de óbito superior a 40%</td>
                        <td> <?= $data['snap']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                    </tr>                    
                </tbody>                
            </table>
            <!-- SNAPII END -->
        </div>
    </body>
</html>