<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Surgery']), ['action' => 'edit', $surgery->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Surgery']), ['action' => 'delete', $surgery->id], ['confirm' => __('Are you sure you want to delete # {0}?', $surgery->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Surgeries']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Surgery']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Professionals']), ['controller' => 'Professionals', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Professional']), ['controller' => 'Professionals', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Surgical Materials']), ['controller' => 'SurgicalMaterials', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Surgical Material']), ['controller' => 'SurgicalMaterials', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Type Of Anesthesias']), ['controller' => 'TypeOfAnesthesias', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Type Of Anesthesia']), ['controller' => 'TypeOfAnesthesias', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="surgeries view col-lg-10 col-md-9">
    <h3><?= h($surgery->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Nome</th>
            <td><?= h($surgery->nome) ?></td>
        </tr>
        <tr>
            <th>Especialidade</th>
            <td><?= h($surgery->especialidade) ?></td>
        </tr>
        <tr>
            <th>Especialidade Cirurgica Auxiliar</th>
            <td><?= h($surgery->especialidade_cirurgica_auxiliar) ?></td>
        </tr>
        <tr>
            <th>Porte Da Cirurgia</th>
            <td><?= h($surgery->porte_da_cirurgia) ?></td>
        </tr>
        <tr>
            <th>Caracteristica Da Cirurgia</th>
            <td><?= h($surgery->caracteristica_da_cirurgia) ?></td>
        </tr>
        <tr>
            <th>Cirurgia Contaminada</th>
            <td><?= h($surgery->cirurgia_contaminada) ?></td>
        </tr>
        <tr>
            <th>Conversao Para</th>
            <td><?= h($surgery->conversao_para) ?></td>
        </tr>
        <tr>
            <th>Adiar Cirurgia Motivo</th>
            <td><?= h($surgery->adiar_cirurgia_motivo) ?></td>
        </tr>
        <tr>
            <th>Suspender Cirurgia Motiv</th>
            <td><?= h($surgery->suspender_cirurgia_motiv) ?></td>
        </tr>
        <tr>
            <th>Cancelar Cirurgia Motivo</th>
            <td><?= h($surgery->cancelar_cirurgia_motivo) ?></td>
        </tr>
        <tr>
            <th>Mudança Na Cirurgia</th>
            <td><?= h($surgery->mudanca_na_cirurgia) ?></td>
        </tr>
        <tr>
            <th>Mudança Na Anestesia</th>
            <td><?= h($surgery->mudanca_na_anestesia) ?></td>
        </tr>
        <tr>
            <th>Houve Complicacao Durante Cirurgia</th>
            <td><?= h($surgery->houve_complicacao_durante_cirurgia) ?></td>
        </tr>
        <tr>
            <th>Setor Nao Programado</th>
            <td><?= h($surgery->setor_nao_programado) ?></td>
        </tr>
        <tr>
            <th>Encaminhado Para Setor Nao Programado Motivo</th>
            <td><?= h($surgery->encaminhado_para_setor_nao_programado_motivo) ?></td>
        </tr>
        <tr>
            <th>Reabordagem Programada</th>
            <td><?= h($surgery->reabordagem_programada) ?></td>
        </tr>
        <tr>
            <th>Retirada De Ortese Ou Protese Motivo</th>
            <td><?= h($surgery->retirada_de_ortese_ou_protese_motivo) ?></td>
        </tr>
        <tr>
            <th>Hospitalization</th>
            <td><?= $surgery->has('hospitalization') ? $this->Html->link($surgery->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $surgery->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($surgery->id) ?></td>
        </tr>
        <tr>
            <th>'Total Dias Do Leito Reservado</th>
            <td><?= $this->Number->format($surgery->total_dias_do_leito_reservado) ?></td>
        </tr>
        <tr>
            <th>'Total De Compressa Cirurgica Usada</th>
            <td><?= $this->Number->format($surgery->total_de_compressa_cirurgica_usada) ?></td>
        </tr>
        <tr>
            <th>'Total De Pinca Extra Usada</th>
            <td><?= $this->Number->format($surgery->total_de_pinca_extra_usada) ?></td>
        </tr>
        <tr>
            <th>'Total De Caixa Extra</th>
            <td><?= $this->Number->format($surgery->total_de_caixa_extra) ?></td>
        </tr>
        <tr>
            <th>Data Da Solicitacao</th>
            <td><?= h($surgery->data_da_solicitacao) ?></tr>
        </tr>
        <tr>
            <th>Data Da Cirurgia</th>
            <td><?= h($surgery->data_da_cirurgia) ?></tr>
        </tr>
        <tr>
            <th>Data Da Liberacao</th>
            <td><?= h($surgery->data_da_liberacao) ?></tr>
        </tr>
        <tr>
            <th>Tempo De Cirurgia Estimado</th>
            <td><?= h($surgery->tempo_de_cirurgia_estimado) ?></tr>
        </tr>
        <tr>
            <th>Hora Da Cirurgia</th>
            <td><?= h($surgery->hora_da_cirurgia) ?></tr>
        </tr>
        <tr>
            <th>Aidar Cirurgia Para Data</th>
            <td><?= h($surgery->aidar_cirurgia_para_data) ?></tr>
        </tr>
        <tr>
            <th>Aidar Cirurgia Para Hora</th>
            <td><?= h($surgery->aidar_cirurgia_para_hora) ?></tr>
        </tr>
        <tr>
            <th>Suspender Cirurgia Para Data</th>
            <td><?= h($surgery->suspender_cirurgia_para_data) ?></tr>
        </tr>
        <tr>
            <th>Suspender Cirurgia Para Hora</th>
            <td><?= h($surgery->suspender_cirurgia_para_hora) ?></tr>
        </tr>
        <tr>
            <th>Visita Pré-Anestésica Data</th>
            <td><?= h($surgery->visita_pre_anestesica_data) ?></tr>
        </tr>
        <tr>
            <th>Visita Pré-Anestésica Hora</th>
            <td><?= h($surgery->visita_pre_anestesica_hora) ?></tr>
        </tr>
        <tr>
            <th>Entrada Na Sala Cirurgica Data</th>
            <td><?= h($surgery->entrada_na_sala_cirurgica_data) ?></tr>
        </tr>
        <tr>
            <th>Entrada Na Sala Cirurgica Hora</th>
            <td><?= h($surgery->entrada_na_sala_cirurgica_hora) ?></tr>
        </tr>
        <tr>
            <th>Realizado Antibiotico Profilaxia Data</th>
            <td><?= h($surgery->realizado_antibiotico_profilaxia_data) ?></tr>
        </tr>
        <tr>
            <th>Realizado Antibiotico Profilaxia Hora</th>
            <td><?= h($surgery->realizado_antibiotico_profilaxia_hora) ?></tr>
        </tr>
        <tr>
            <th>Inicio Da Anestesia Hora</th>
            <td><?= h($surgery->inicio_da_anestesia_hora) ?></tr>
        </tr>
        <tr>
            <th>Termino Da Anestesia Hora</th>
            <td><?= h($surgery->termino_da_anestesia_hora) ?></tr>
        </tr>
        <tr>
            <th>Inicio Da Cirurgia Hora</th>
            <td><?= h($surgery->inicio_da_cirurgia_hora) ?></tr>
        </tr>
        <tr>
            <th>Termino Da Cirurgia Hora</th>
            <td><?= h($surgery->termino_da_cirurgia_hora) ?></tr>
        </tr>
        <tr>
            <th>Data Da Instalacao Ortese Ou Protese</th>
            <td><?= h($surgery->data_da_instalacao_ortese_ou_protese) ?></tr>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($surgery->created) ?></tr>
        </tr>
        <tr>
            <th>Outra Especialidade Cirurgica Em Apoio</th>
            <td><?= $surgery->outra_especialidade_cirurgica_em_apoio ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Anestesia Adequada Foi Confirmada</th>
            <td><?= $surgery->anestesia_adequada_foi_confirmada ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Internacao Previa A Cirurgia</th>
            <td><?= $surgery->internacao_previa_a_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Deseja Reservar Leito</th>
            <td><?= $surgery->deseja_reservar_leito ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Pós-Operatório Em Uti</th>
            <td><?= $surgery->pos_operatorio_em_uti ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Conversao Da Caracteristica Da Cirurgia</th>
            <td><?= $surgery->conversao_da_caracteristica_da_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Adiar Cirurgia</th>
            <td><?= $surgery->adiar_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Suspender Cirurgia</th>
            <td><?= $surgery->suspender_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Cancelar Cirurgia</th>
            <td><?= $surgery->cancelar_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Visita Pré-Anestésica</th>
            <td><?= $surgery->visita_pre_anestesica ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Entrada Na Sala Cirurgica</th>
            <td><?= $surgery->entrada_na_sala_cirurgica ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Realizado Antibiotico Profilaxia</th>
            <td><?= $surgery->realizado_antibiotico_profilaxia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Houve Mudanca Na Cirurgia</th>
            <td><?= $surgery->houve_mudanca_na_cirurgia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Houve Mudanca Na Anestesia</th>
            <td><?= $surgery->houve_mudanca_na_anestesia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Uso De Compressa Cirurgica</th>
            <td><?= $surgery->uso_de_compressa_cirurgica ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Uso De Pinca Extra</th>
            <td><?= $surgery->uso_de_pinca_extra ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Uso De Caixa Extra</th>
            <td><?= $surgery->uso_de_caixa_extra ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Encaminhado Para Setor De Destino Programado</th>
            <td><?= $surgery->encaminhado_para_setor_de_destino_programado ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Houve Reabordagem Cirurgica</th>
            <td><?= $surgery->houve_reabordagem_cirurgica ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Retirada De Ortese Ou Protese</th>
            <td><?= $surgery->retirada_de_ortese_ou_protese ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Professionals']) ?></h4>
        <?php if (!empty($surgery->professionals)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>User Id</th>
                <th>Concil Number</th>
                <th>Unit Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($surgery->professionals as $professionals): ?>
            <tr>
                <td><?= h($professionals->id) ?></td>
                <td><?= h($professionals->user_id) ?></td>
                <td><?= h($professionals->concil_number) ?></td>
                <td><?= h($professionals->unit_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Professionals', 'action' => 'view', $professionals->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Professionals', 'action' => 'edit', $professionals->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Professionals', 'action' => 'delete', $professionals->id], ['confirm' => __('Are you sure you want to delete # {0}?', $professionals->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Surgical Materials']) ?></h4>
        <?php if (!empty($surgery->surgical_materials)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Nome</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($surgery->surgical_materials as $surgicalMaterials): ?>
            <tr>
                <td><?= h($surgicalMaterials->id) ?></td>
                <td><?= h($surgicalMaterials->nome) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'SurgicalMaterials', 'action' => 'view', $surgicalMaterials->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'SurgicalMaterials', 'action' => 'edit', $surgicalMaterials->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'SurgicalMaterials', 'action' => 'delete', $surgicalMaterials->id], ['confirm' => __('Are you sure you want to delete # {0}?', $surgicalMaterials->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Type Of Anesthesias']) ?></h4>
        <?php if (!empty($surgery->type_of_anesthesias)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Nome</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($surgery->type_of_anesthesias as $typeOfAnesthesias): ?>
            <tr>
                <td><?= h($typeOfAnesthesias->id) ?></td>
                <td><?= h($typeOfAnesthesias->nome) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'TypeOfAnesthesias', 'action' => 'view', $typeOfAnesthesias->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'TypeOfAnesthesias', 'action' => 'edit', $typeOfAnesthesias->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'TypeOfAnesthesias', 'action' => 'delete', $typeOfAnesthesias->id], ['confirm' => __('Are you sure you want to delete # {0}?', $typeOfAnesthesias->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
