<?php

    echo $this->element('internacao-menu');

    $via = [
      'CNG' => 'CNG',
      'Enteral' => 'Enteral',
      'GTT' => 'GTT',
      'IM' => 'IM',
      'IV' => 'IV',
      'Nasal' => 'Nasal',
      'NBZ' => 'NBZ',
      'Ocular' => 'Ocular',
      'Oral' => 'Oral',
      'Retal' => 'Retal',
      'SC'=> 'SC',
      'Spray' => 'Spray',
      'Tópico' => 'Tópico',
      'Tecal' => 'Tecal',
      'Intrauricular' => 'Intrauricular',
      'Intracavitária' => 'Intracavitária',
      'NSA' => 'NSA'
   ];

   $frequencies =  [
         '1X SEM' => '1X SEM',
         'SEG QUA SEX' => 'SEG QUA SEX',
         'TER QUI SAB' => 'TER QUI SAB',
         'DIAS ALTERNADOS' => 'DIAS ALTERNADOS',
         '1X DIA' => '1X DIA',
         '12/12 H' => '12/12 H',
         '8/8 H' => '8/8 H',
         '6/6 H' => '6/6 H',
         '4/4 H' => '4/4 H',
         '3/3 H' => '3/3 H',
         '2/2 H' => '2/2 H',
         '1/1 H' =>'1/1 H',
         'ACM' => 'ACM',
         'SOS' => 'SOS',
         'BI' => 'BI',
         'NSA' => 'NSA',
   ];

   $categories = [
      'Medicamentos' => 'Medicamentos',
      'Exame de Imagem' => 'Exame de Imagem',
      'Exame Laboratorial' => 'Exame Laboratorial',
      'Material'=> 'Material',
      'Assistencia' => 'Assistencia'
   ];

   $surveillanceSignalings = [
      'Alta Vigilância' => 'Alta Vigilância',
      'Med. Potencialmente Perigosas' => 'Med. Potencialmente Perigosas',
      'Não Padronizada' => 'Não Padronizada'
   ];

   $presentations = [
      'Bisnaga' => 'Bisnaga',
      'Cápsula' => 'Cápsula',
      'Comprimido' => 'Comprimido',
      'Frasco' => 'Frasco',
      'Gotas' => 'Gotas',
      'Microgotas' => 'Microgotas',
      'Pastilha' => 'Pastilha',
      'Puff' => 'Puff',
      'Sachê' => 'Sachê',
      'Spray' => 'Spray',
      'NSA' => 'NSA'
   ];

?>
<div class="medications form col-md-9 columns content">

   <div  class="btn-group import-button-group">
      <button  type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
           <i class="glyphicon glyphicon-download-alt"></i>
           Importação de itens
           <span class="caret"></span>
       </button>
       <ul class="dropdown-menu">
           <li>
             <?=
                 $this->Html->link(
                    "Dowload da planilha padrão",
                    "/importar-medicamentos.xlsx");
             ?>
           </li>
           <li data-toggle="modal" data-target="#myModal">
               <a>Importar</a>
           </li>
       </ul>
   </div>
  <br><br>
</div>

<div class="medications form col-md-9 columns content">
   <?= $this->Form->create($systemMedication) ?>
      <?php

           echo $this->Form->hidden('professional_id', ['value'=>1, 'empty'=>true, 'label'=>false]);
           echo $this->Form->hidden('unit_id', ['value'=>$unitId, 'empty'=>true, 'label'=>false]);

           echo $this->Form->input('name', ['required' => true, 'empty'=>true, 'label'=>['text'=>'Nome do item', 'class'=>'form-input'] ]);

           echo $this->Form->input('category', ['options'=>$categories,'empty'=>true,'required' => true, 'label'=>['text'=>'Categoria:', 'class'=>'form-input'] ]);

           echo "<div class='hide-element drug-type-fields'>";

              echo $this->Form->input('presentation', ['options'=>$presentations, 'empty'=>true, 'label'=>['text'=>'Apresentação:', 'class'=>'form-input'] ]);

              echo $this->Form->input('quantity', ['empty'=>true, 'label'=>['text'=>'Quatidade disponível:', 'class'=>'form-input'] ]);

              echo $this->Form->input('channel', ['options'=>$via, 'empty'=>true, 'label'=>['text'=>'Via de administração:', 'class'=>'form-input'] ]);

              echo $this->Form->input('frequency', ['options' => $frequencies, 'empty'=>true, 'label'=>['text'=>'Frequência:', 'class'=>'form-input'] ]);

              echo '<div class="funkyradio">';
                  echo '<div class="funkyradio-primary">';
                      echo $this->Form->checkbox('controlled_drug', ['id'=>'controlled_drug']);
                      echo '<label for="controlled_drug">Medicamento de uso controlado</label>';
                  echo "</div>";
              echo "</div>";

              echo '<div class="funkyradio">';
                  echo '<div class="funkyradio-primary">';
                      echo $this->Form->checkbox('is_antibiotic', ['onchange' => "javascript:toggleElement('.antibiotic_justification');", 'id'=>'is_antibiotic']);
                      echo '<label for="is_antibiotic">Esse medicamento é um antibiótico</label>';
                  echo "</div>";
              echo "</div>";

              echo "<div class='hide-element antibiotic_justification'><br>";
                  echo $this->Form->input('antibiotic_justification', ['type'=>'textarea', 'label'=>['text'=>'Justificativa para emprego de antibiótico:', 'class'=>'form-input']]);
              echo "</div>";

              echo '<div class="funkyradio">';
                  echo '<div class="funkyradio-primary">';
                      echo $this->Form->checkbox('is_surveillance_signed', ['onchange' => "javascript:toggleElement('.surveillance_signed');", 'id'=>'is_surveillance_signed']);
                      echo '<label for="is_surveillance_signed">Sinalização de vigilância</label>';
                  echo "</div>";
              echo "</div>";

              echo "<div class='hide-element surveillance_signed'><br>";
                  echo $this->Form->input('surveillance_signaling', ['options'=> $surveillanceSignalings, 'empty'=>true ,'label'=>['text'=>'Qual?', 'class'=>'form-input']]);
              echo "</div>";

           echo "</div>";

           echo '<div class="funkyradio">';
               echo '<div class="funkyradio-primary">';
                   echo $this->Form->checkbox('is_restricted_by_sectors', ['onchange' => "javascript:toggleElement('.restricted_by_sectors');",'onclick'=>'resetHidden(this.checked,".restricted_by_sectors");', 'id'=>'is_restricted_by_sectors']);
                   echo '<label "class"="restrict-check" for="is_restricted_by_sectors">Restrição de uso por setor(es)</label>';
               echo "</div>";
           echo "</div>";

           echo "<div class='hide-element restricted_by_sectors'><br>";
              echo $this->Form->input('restricted_sectors._ids', ['options'=>$sectors,'class'=>'multiselect','label'=>['text'=>'Setor (es):','class'=>'form-input '],'type' => 'select', 'multiple' => true]);
           echo "</div>";

           echo '<div class="funkyradio">';
               echo '<div class="funkyradio-primary">';
                   echo $this->Form->checkbox('is_restricted_by_users', ['onchange' => "javascript:toggleElement('.restricted_by_users');",'onclick'=>'resetHidden(this.checked,".restricted_by_users");','id'=>'is_restricted_by_users']);
                   echo '<label "class"="restrict-check" for="is_restricted_by_users">Restrição de uso por usuário(s)</label>';
               echo "</div>";
           echo "</div>";

           echo "<div class='hide-element restricted_by_users'><br>";

              echo $this->Form->input('restricted_professionals._ids', ['options'=>$professionals,'class'=>'multiselect','label'=>['text'=>'Retringir por nome(s) :','class'=>'form-input '],'type' => 'select', 'multiple' => true]);

              echo
               $this->Form->input('restricted_specialties._ids', ['options'=>$specialties,'class'=>'multiselect','label'=>['text'=>'Retringir por especialidade(s) :','class'=>'form-input '],'type' => 'select', 'multiple' => true]);

           echo "</div>";

           echo '<div class="unitary-price">';
           echo $this->Form->input('unitary_price', ['type' => 'text', 'empty'=>true, 'class' => 'money number ' , 'label'=>['text'=>'Valor unitário(R$)', 'class'=>'form-input'] ]);
           echo "</div>";

           echo '<div class="funkyradio">';
               echo '<div class="funkyradio-primary">';
                   echo $this->Form->checkbox('accepts_devolution', [ 'id'=>'accepts_devolution']);
                   echo '<label for="accepts_devolution">Aceita devolução</label>';
               echo "</div>";
           echo "</div>";
           echo "</br>";

      ?>
      <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
      <?= $this->Form->button(__('Salvar')) ?>
      <?= $this->Form->end() ?>
      <br><br><br>
</div>


<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
<div class="modal-dialog">

  <!-- Modal content-->
  <div class="modal-content">

    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal">&times;</button>
      <h4 class="modal-title">Importar itens</h4>
    </div>

    <div style="padding: 40px;">
        <?= $this->Form->create('index', ['id'=>'import-form','type'=>'file','url'=>'/SystemMedications/importItens']) ?>
          <?= $this->Form->input('sheet',['required'=>true,'type'=>'file','label'=>['text'=>'Selecione o arquivo para importação:']]); ?>
          <button id="subButton" type="submit" onclick="this.form.submit()"  class="btn btn-primary ">Iniciar importação</button>
          <br>
          <div class="hide-loader" style="display: none">
               <div class="loader hide-loader" ></div><span>Importando, por favor aguarde...</span>
          </div>

        <?= $this->Form->end() ?>
    </div>

    <div class="modal-footer">
      <button type="button" class="btn close-modal btn-primary" data-dismiss="modal">Fechar</button>
    </div>
  </div>
</div>
</div>

<script>

function resetHidden(isChecked, hiddenClass) {
   if(!isChecked) {
      $(hiddenClass).find('select.multiselect').multiselect('clearSelection');
   }
}

(function() {
   $('#category').change(function() {
         var c = $(this).val();
         if(c == 'Medicamentos') {
            $('.drug-type-fields').fadeIn();
         }
         else {
            $('.drug-type-fields input').val('');
            $('.drug-type-fields textarea').val('');
            $('.drug-type-fields input[type=checkbox]').each(function() {
                $(this).prop('checked', false);
            });
            $('.drug-type-fields hide-element').fadeOut();
            $('.drug-type-fields').fadeOut();
         }

   });

   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    array('controller' => 'Users', 'action' => 'login'),
            array('class'=>'btn btn-default ', 'escape' => false)
        ) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

   var link3 =' <?= $this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link4 =' <?= $this->Html->link('Itens', ['controller' => 'SystemMedications', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= link4;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Editar Item</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();

$('document').ready(function(){

  $('.close-modal').click(function(){
      $('#import-form')[0].reset();
      $('.hide-loader').hide();
      $('#subButton').show();
      $('#subButton').attr('disabled',false);
  });

  $('#subButton').click(function(){
      $(this).attr('disabled',true);
      $(this).hide();
      $('.hide-loader').show();
  });

});
</script>
