<?php
namespace App\Test\TestCase\Model\Table;

use App\Model\Table\MedicalOpinionRequestsTable;
use Cake\ORM\TableRegistry;
use Cake\TestSuite\TestCase;

/**
 * App\Model\Table\MedicalOpinionRequestsTable Test Case
 */
class MedicalOpinionRequestsTableTest extends TestCase
{

    /**
     * Test subject
     *
     * @var \App\Model\Table\MedicalOpinionRequestsTable
     */
    public $MedicalOpinionRequests;

    /**
     * Fixtures
     *
     * @var array
     */
    public $fixtures = [
        'app.medical_opinion_requests',
        'app.requested_specialties',
        'app.professionals',
        'app.users',
        'app.roles',
        'app.log',
        'app.units',
        'app.groups',
        'app.health_insurance_plans',
        'app.hospitalizations',
        'app.patients',
        'app.allergies',
        'app.diagnostics',
        'app.glasgow_coma_scales',
        'app.responsibles',
        'app.telephones',
        'app.responsibles_telephones',
        'app.screenings',
        'app.patients_telephones',
        'app.patients_units',
        'app.origins',
        'app.bundle',
        'app.cardiac_surgery_checklists',
        'app.daily_safety_checklists',
        'app.fugulin_and_braden',
        'app.historic_of_localizations',
        'app.rooms',
        'app.sectors',
        'app.types',
        'app.indicators_sectors',
        'app.professional_sectors',
        'app.infections',
        'app.initial_nutritional_assessment',
        'app.medical_bulletins',
        'app.prescriptions',
        'app.signs',
        'app.goals',
        'app.goals_units',
        'app.units_users',
        'app.medical_opinion_answer',
        'app.specialties',
        'app.professionals_specialties',
        'app.areas_of_occupation',
        'app.areas_of_occupation_professionals'
    ];

    /**
     * setUp method
     *
     * @return void
     */
    public function setUp()
    {
        parent::setUp();
        $config = TableRegistry::exists('MedicalOpinionRequests') ? [] : ['className' => 'App\Model\Table\MedicalOpinionRequestsTable'];
        $this->MedicalOpinionRequests = TableRegistry::get('MedicalOpinionRequests', $config);
    }

    /**
     * tearDown method
     *
     * @return void
     */
    public function tearDown()
    {
        unset($this->MedicalOpinionRequests);

        parent::tearDown();
    }

    /**
     * Test initialize method
     *
     * @return void
     */
    public function testInitialize()
    {
        $this->markTestIncomplete('Not implemented yet.');
    }

    /**
     * Test validationDefault method
     *
     * @return void
     */
    public function testValidationDefault()
    {
        $this->markTestIncomplete('Not implemented yet.');
    }

    /**
     * Test buildRules method
     *
     * @return void
     */
    public function testBuildRules()
    {
        $this->markTestIncomplete('Not implemented yet.');
    }
}
