<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ClinicTevProtocolsRiskFactors Controller
 *
 * @property \App\Model\Table\ClinicTevProtocolsRiskFactorsTable $ClinicTevProtocolsRiskFactors
 */
class ClinicTevProtocolsRiskFactorsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['RiskFactors', 'ClinicTevProtocols']
        ];
        $clinicTevProtocolsRiskFactors = $this->paginate($this->ClinicTevProtocolsRiskFactors);

        $this->set(compact('clinicTevProtocolsRiskFactors'));
        $this->set('_serialize', ['clinicTevProtocolsRiskFactors']);
    }

    /**
     * View method
     *
     * @param string|null $id Clinic Tev Protocols Risk Factor id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->get($id, [
            'contain' => ['RiskFactors', 'ClinicTevProtocols']
        ]);

        $this->set('clinicTevProtocolsRiskFactor', $clinicTevProtocolsRiskFactor);
        $this->set('_serialize', ['clinicTevProtocolsRiskFactor']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->newEntity();
        if ($this->request->is('post')) {
            $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->patchEntity($clinicTevProtocolsRiskFactor, $this->request->data);
            if ($this->ClinicTevProtocolsRiskFactors->save($clinicTevProtocolsRiskFactor)) {
                $this->Flash->success(__('The clinic tev protocols risk factor has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The clinic tev protocols risk factor could not be saved. Please, try again.'));
            }
        }
        $riskFactors = $this->ClinicTevProtocolsRiskFactors->RiskFactors->find('list', ['limit' => 200]);
        $clinicTevProtocols = $this->ClinicTevProtocolsRiskFactors->ClinicTevProtocols->find('list', ['limit' => 200]);
        $this->set(compact('clinicTevProtocolsRiskFactor', 'riskFactors', 'clinicTevProtocols'));
        $this->set('_serialize', ['clinicTevProtocolsRiskFactor']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Clinic Tev Protocols Risk Factor id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->patchEntity($clinicTevProtocolsRiskFactor, $this->request->data);
            if ($this->ClinicTevProtocolsRiskFactors->save($clinicTevProtocolsRiskFactor)) {
                $this->Flash->success(__('The clinic tev protocols risk factor has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The clinic tev protocols risk factor could not be saved. Please, try again.'));
            }
        }
        $riskFactors = $this->ClinicTevProtocolsRiskFactors->RiskFactors->find('list', ['limit' => 200]);
        $clinicTevProtocols = $this->ClinicTevProtocolsRiskFactors->ClinicTevProtocols->find('list', ['limit' => 200]);
        $this->set(compact('clinicTevProtocolsRiskFactor', 'riskFactors', 'clinicTevProtocols'));
        $this->set('_serialize', ['clinicTevProtocolsRiskFactor']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Clinic Tev Protocols Risk Factor id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $clinicTevProtocolsRiskFactor = $this->ClinicTevProtocolsRiskFactors->get($id);
        if ($this->ClinicTevProtocolsRiskFactors->delete($clinicTevProtocolsRiskFactor)) {
            $this->Flash->success(__('The clinic tev protocols risk factor has been deleted.'));
        } else {
            $this->Flash->error(__('The clinic tev protocols risk factor could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
