<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * CurbScores Controller
 *
 * @property \App\Model\Table\CurbScoresTable $CurbScores
 */
class CurbScoresController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CribScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $curbScores = $this->paginate($this->CurbScores);

        $this->set(compact('curbScores'));
        $this->set('_serialize', ['curbScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Curb Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $curbScore = $this->CurbScores->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('curbScore', $curbScore);
        $this->set('_serialize', ['curbScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');
        $pacient       = $pacient_table->findById($pacient_id)->first();

        $curbScore = $this->CurbScores->newEntity();
        if ($this->request->is('post')) {
            $curbScore = $this->CurbScores->patchEntity($curbScore, $this->request->data);
            if ($this->CurbScores->save($curbScore)) {
                $this->Flash->success(__('O registro  foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $x = $curbScore->errors();
                Log::write('debug', 'x');
                Log::write('debug', $x);

                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->CurbScores->Hospitalizations->find('list', ['limit' => 200]);

        $this->set(compact('curbScore', 'hospitalizations', 'pacient'));
        $this->set('_serialize', ['curbScore']);
    }

/**
 * Edit method
 *
 * @param string|null $id Curb Score id.
 * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
 * @throws \Cake\Network\Exception\NotFoundException When record not found.
 */
    public function edit($id = null)
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');
        $pacient       = $pacient_table->findById($pacient_id)->first();

        $curbScore = $this->CurbScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $curbScore = $this->CurbScores->patchEntity($curbScore, $this->request->data);
            if ($this->CurbScores->save($curbScore)) {
                $this->Flash->success(__('O registro  foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->CurbScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('curbScore', 'hospitalizations', 'pacient'));
        $this->set('_serialize', ['curbScore']);
    }

/**
 * Delete method
 *
 * @param string|null $id Curb Score id.
 * @return \Cake\Network\Response|null Redirects to index.
 * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
 */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $curbScore = $this->CurbScores->get($id);
        if ($this->CurbScores->delete($curbScore)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não foi deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
