<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * FugulinBradenScales Controller
 *
 * @property \App\Model\Table\FugulinBradenScalesTable $FugulinBradenScales
 */
class FugulinBradenScalesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Enfermagem');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        return true;
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CribScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');

        $this->paginate = [
            'contain'    => ['FugulinBradenScales', 'BradenScales', 'NasScores', 'SkinIntegrities', 'IdentificationOfRisks'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],
        ];

        $hospitalizations = TableRegistry::get('Hospitalizations');

        $hospitalizations = $this->paginate($hospitalizations);

        $this->set(compact('hospitalizations'));
        $this->set('_serialize', ['hospitalization']);
    }

    /**
     * View method
     *
     * @param string|null $id Fugulin Braden Scale id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $fugulinBradenScale = $this->FugulinBradenScales->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('fugulinBradenScale', $fugulinBradenScale);
        $this->set('_serialize', ['fugulinBradenScale']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $fugulinBradenScale = $this->FugulinBradenScales->newEntity();
        if ($this->request->is('post')) {
            $fugulinBradenScale = $this->FugulinBradenScales->patchEntity($fugulinBradenScale, $this->request->data);
            if ($this->FugulinBradenScales->save($fugulinBradenScale)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $x = $fugulinBradenScale->errors();
                Log::write('debug', 'x');
                Log::write('debug', $x);
                Log::write('debug', $fugulinBradenScale);
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->FugulinBradenScales->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('fugulinBradenScale', 'hospitalizations'));
        $this->set('_serialize', ['fugulinBradenScale']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Fugulin Braden Scale id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $fugulinBradenScale = $this->FugulinBradenScales->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $fugulinBradenScale = $this->FugulinBradenScales->patchEntity($fugulinBradenScale, $this->request->data);
            if ($this->FugulinBradenScales->save($fugulinBradenScale)) {
                $this->Flash->success(__('The fugulin braden scale has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->FugulinBradenScales->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('fugulinBradenScale', 'hospitalizations'));
        $this->set('_serialize', ['fugulinBradenScale']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Fugulin Braden Scale id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $fugulinBradenScale = $this->FugulinBradenScales->get($id);
        if ($this->FugulinBradenScales->delete($fugulinBradenScale)) {
            $this->Flash->success(__('The fugulin braden scale has been deleted.'));
        } else {
            $this->Flash->error(__('The fugulin braden scale could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function desactivate($id = null)
    {
        $this->request->allowMethod(['post', 'desactivate']);
        $fugulinBradenScale            = $this->FugulinBradenScales->get($id);
        $fugulinBradenScale->is_active = false;

        if ($this->FugulinBradenScales->save($fugulinBradenScale)) {
            $this->Flash->success(__('O registro foi suspenso com sucesso.'));
        } else {
            $this->Flash->error(__('O registro não pode ser suspenso. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'fugulinBradenScales', 'action' => 'index']);
    }

    public function activate($id = null)
    {

        $this->request->allowMethod(['post', 'activate']);

        $fugulinBradenScale            = $this->FugulinBradenScales->get($id);
        $fugulinBradenScale->is_active = true;

        if ($this->FugulinBradenScales->save($fugulinBradenScale)) {

            $this->Flash->success(__('O registro foi ativado com sucesso.'));
        } else {
            $this->Flash->error(__('O registro não pode ser ativado. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'fugulinBradenScales', 'action' => 'index']);

    }
}
