<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * SuspectedMeProtocols Controller
 *
 * @property \App\Model\Table\SuspectedMeProtocolsTable $SuspectedMeProtocols
 */
class SuspectedMeProtocolsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Suspeita ME');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

        $screening_id = $session->read('screening_id');
        $this->set('screening_id', $screening_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $suspectedMeProtocols = $this->paginate($this->SuspectedMeProtocols);

        $this->set(compact('suspectedMeProtocols'));
        $this->set('_serialize', ['suspectedMeProtocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Suspected Me Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $suspectedMeProtocol = $this->SuspectedMeProtocols->get($id, [
            'contain' => ['Hospitalizations', 'SupplementaryExaminations'],
        ]);

        $this->set('suspectedMeProtocol', $suspectedMeProtocol);
        $this->set('_serialize', ['suspectedMeProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $exam_table          = TableRegistry::get('SupplementaryExaminations');
        $suspectedMeProtocol = $this->SuspectedMeProtocols->newEntity();
        if ($this->request->is('post')) {
            $suspectedMeProtocol = $this->SuspectedMeProtocols->patchEntity($suspectedMeProtocol, $this->request->data);
            $exam                = $exam_table->patchEntity($suspectedMeProtocol, $this->request->data['supplementary_examinations']);
            if ($this->SuspectedMeProtocols->save($suspectedMeProtocol)) {
                $this->Flash->success(__('O registro foi salvo.'));
                //return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);

                return $this->redirect(['action' => 'index']);

            } else {

                Log::write('debug', '$suspectedMeProtocol');
                Log::write('debug', $suspectedMeProtocol);
                Log::write('debug', $suspectedMeProtocol->errors());

                $this->Flash->error(__('O registro não pode ser salvo.'));
            }
        }
        $hospitalizations = $this->SuspectedMeProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('suspectedMeProtocol', 'hospitalizations'));
        $this->set('_serialize', ['suspectedMeProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Suspected Me Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $suspectedMeProtocol = $this->SuspectedMeProtocols->get($id, [
            'contain' => ['SupplementaryExaminations', 'SedativeDrugs', 'ObtainedOrgans'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $suspectedMeProtocol = $this->SuspectedMeProtocols->patchEntity($suspectedMeProtocol, $this->request->data);
            if ($this->SuspectedMeProtocols->save($suspectedMeProtocol)) {
                $this->Flash->success(__('O Registro foi salvo.'));
                //return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
                //return $this->redirect(['action' => 'index']);
            } else {
                Log::write('debug', '$suspectedMeProtocol');
                Log::write('debug', $suspectedMeProtocol);
                Log::write('debug', $suspectedMeProtocol->errors());
                $this->Flash->error(__('O registro não pode ser salvo.'));
            }
        }
        $hospitalizations = $this->SuspectedMeProtocols->Hospitalizations->find('list', ['limit' => 200]);

        $this->set(compact('suspectedMeProtocol', 'hospitalizations'));
        $this->set('_serialize', ['suspectedMeProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Suspected Me Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $suspectedMeProtocol = $this->SuspectedMeProtocols->get($id);
        if ($this->SuspectedMeProtocols->delete($suspectedMeProtocol)) {
            $this->Flash->success(__('The suspected me protocol has been deleted.'));
        } else {
            $this->Flash->error(__('The suspected me protocol could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
