<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * BarthelIndex Entity.
 *
 * @property int $id
 * @property string $alimentacao
 * @property string $banho
 * @property string $atividades_rotineiras
 * @property string $vestir_se
 * @property string $intestino
 * @property string $sistema_urinario
 * @property string $uso_do_banheiro
 * @property string $transferencia
 * @property string $mobilidade
 * @property string $escadas
 * @property string $total_pontos
 * @property bool $is_active
 * @property \Cake\I18n\Time $created
 * @property int $barthel_id
 * @property string $alimentacao_24
 * @property string $alimentacao_alta
 * @property string $banho_24
 * @property string $banho_alta
 * @property string $atividades_rotineiras_24
 * @property string $atividades_rotineiras_alta
 * @property string $vestir_se_24
 * @property string $vestir_se_alta
 * @property string $intestino_24
 * @property string $intestino_alta
 * @property string $uso_do_banheiro_24
 * @property string $uso_do_banheiro_alta
 * @property string $transferencia_24
 * @property string $transferencia_alta
 * @property string $mobilidade_24
 * @property string $mobilidade_alta
 * @property string $escadas_24
 * @property string $escadas_alta
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Barthel $barthel
 */
class BarthelIndex extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*'  => true,
        'id' => false,
    ];

    public function typeBarthelIndexes($barthelIndexO)
    {
        $barthelIndex = $barthelIndexO;

        //echo $barthelIndex['total_pontos_admissao'];

        if ($barthelIndex['total_pontos_admissao'] != 0) {
            $tipo = "Admissão";
        } else if ($barthelIndex['total_pontos_exturbacao'] != 0) {
            $tipo = "24h após a extubação";
        } else {
            $tipo = "Alta";
        }

        return $tipo;
    }

    public function somaBarthelIndexes($barthelIndexO)
    {
        $barthelIndex = $barthelIndexO;

        //echo $barthelIndex['total_pontos_admissao'];

        if ($barthelIndex['total_pontos_admissao'] != 0) {
            $soma = $barthelIndex['total_pontos_admissao'];
        } else if ($barthelIndex['total_pontos_exturbacao'] != 0) {
            $soma = $barthelIndex['total_pontos_exturbacao'];
        } else {
            $soma = $barthelIndex['total_pontos_alta'];
        }

        return $soma;
    }
}
