<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Hospitalization Entity.
 *
 * @property int $id
 * @property int $patient_id
 * @property \App\Model\Entity\Patient $patient
 * @property string $health_care_number
 * @property string $type
 * @property string $complementary_health
 * @property \Cake\I18n\Time $expected_discharge_day
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property int $origin_id
 * @property \App\Model\Entity\Origin $origin
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property \Cake\I18n\Time $created
 * @property string $updated
 * @property bool $readmission_to_hospital_until_30_days
 * @property bool $rehospitalization_up_24
 * @property float $weight
 * @property float $height
 * @property string $systemic_diagnosis
 * @property int $sector_id
 * @property \App\Model\Entity\Sector $sector
 * @property string $numero_do_prontuario
 * @property float $imc
 * @property int $medical_care_id
 * @property \App\Model\Entity\MedicalCare $medical_care
 * @property \App\Model\Entity\ApacheIiScore[] $apache_ii_scores
 * @property \App\Model\Entity\BarthelIndex[] $barthel_indexes
 * @property \App\Model\Entity\BradenScale[] $braden_scales
 * @property \App\Model\Entity\Bundle[] $bundles
 * @property \App\Model\Entity\CardiacSurgeryChecklist[] $cardiac_surgery_checklists
 * @property \App\Model\Entity\NeonatalChecklist[] $neonatal_checklists
 * @property \App\Model\Entity\ChestPainProtocol[] $chest_pain_protocols
 * @property \App\Model\Entity\ClinicTevProtocol[] $clinic_tev_protocols
 * @property \App\Model\Entity\CribScore[] $crib_scores
 * @property \App\Model\Entity\Culture[] $cultures
 * @property \App\Model\Entity\CurbScore[] $curb_scores
 * @property \App\Model\Entity\DailySafetyChecklist[] $daily_safety_checklists
 * @property \App\Model\Entity\Diagnostic[] $diagnostics
 * @property \App\Model\Entity\Discharge[] $discharges
 * @property \App\Model\Entity\FugulinBradenScale[] $fugulin_braden_scales
 * @property \App\Model\Entity\HistoricPatientMovement[] $historic_patient_movements
 * @property \App\Model\Entity\IdentificationOfRisk[] $identification_of_risks
 * @property \App\Model\Entity\Infection[] $infections
 * @property \App\Model\Entity\InformedConsentForm[] $informed_consent_forms
 * @property \App\Model\Entity\ItuPreventionBundle[] $itu_prevention_bundles
 * @property \App\Model\Entity\MedicalBulletin[] $medical_bulletins
 * @property \App\Model\Entity\MedicalOpinionRequest[] $medical_opinion_requests
 * @property \App\Model\Entity\NasScore[] $nas_scores
 * @property \App\Model\Entity\NutritionalAssessment[] $nutritional_assessments
 * @property \App\Model\Entity\ObstetricSurgeryChecklist[] $obstetric_surgery_checklists
 * @property \App\Model\Entity\PavPreventionBundle[] $pav_prevention_bundles
 * @property \App\Model\Entity\PreAnestheticVisit[] $pre_anesthetic_visits
 * @property \App\Model\Entity\PreDeliricScore[] $pre_deliric_scores
 * @property \App\Model\Entity\Prescription[] $prescriptions
 * @property \App\Model\Entity\SafeSurgeryBundle[] $safe_surgery_bundles
 * @property \App\Model\Entity\SapsIiiScore[] $saps_iii_scores
 * @property \App\Model\Entity\SepseProtocol[] $sepse_protocols
 * @property \App\Model\Entity\SkinIntegrity[] $skin_integrities
 * @property \App\Model\Entity\SnapIiScore[] $snap_ii_scores
 * @property \App\Model\Entity\SofaEscore[] $sofa_escores
 * @property \App\Model\Entity\StrengthAssessmentScale[] $strength_assessment_scales
 * @property \App\Model\Entity\SupportiveMeasure[] $supportive_measures
 * @property \App\Model\Entity\Surgery[] $surgeries
 * @property \App\Model\Entity\SurgicalChecklist[] $surgical_checklists
 * @property \App\Model\Entity\SurgicalTevProtocol[] $surgical_tev_protocols
 * @property \App\Model\Entity\SuspectedMeProtocol[] $suspected_me_protocols
 * @property \App\Model\Entity\VentilatoryCarePlan[] $ventilatory_care_plans
 */
class Hospitalization extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
