<?php
namespace App\Model\Table;

use App\Model\Entity\ClinicTevProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ClinicTevProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $RiskFactors
 */
class ClinicTevProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('clinic_tev_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsToMany('RiskFactors', [
            'foreignKey' => 'clinic_tev_protocol_id',
            'targetForeignKey' => 'risk_factor_id',
            'joinTable' => 'clinic_tev_protocols_risk_factors'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->date('indicacao_profilaxia_data')
            ->allowEmpty('indicacao_profilaxia_data');

        $validator
            ->time('indicacao_profilaxia_hora')
            ->allowEmpty('indicacao_profilaxia_hora');

        $validator
            ->boolean('sangramento_ativo')
            ->allowEmpty('sangramento_ativo');

        $validator
            ->boolean('ulcera')
            ->allowEmpty('ulcera');

        $validator
            ->boolean('has')
            ->allowEmpty('has');

        $validator
            ->boolean('coagulograma')
            ->allowEmpty('coagulograma');

        $validator
            ->boolean('alergia')
            ->allowEmpty('alergia');

        $validator
            ->boolean('insuficiencia_renal')
            ->allowEmpty('insuficiencia_renal');

        $validator
            ->boolean('cirurgia')
            ->allowEmpty('cirurgia');

        $validator
            ->boolean('coleta_lcr')
            ->allowEmpty('coleta_lcr');

        $validator
            ->boolean('enoxaparina_1')
            ->allowEmpty('enoxaparina_1');

        $validator
            ->boolean('enoxaparina_2')
            ->allowEmpty('enoxaparina_2');

        $validator
            ->boolean('enoxaparina_3')
            ->allowEmpty('enoxaparina_3');

        $validator
            ->boolean('enoxaparina_4')
            ->allowEmpty('enoxaparina_4');

        $validator
            ->boolean('meias_elastica')
            ->allowEmpty('meias_elastica');

        $validator
            ->boolean('compressao_pneumatica')
            ->allowEmpty('compressao_pneumatica');

        $validator
            ->boolean('nenhum')
            ->allowEmpty('nenhum');

        $validator
            ->date('metodo_mecanico_inicio')
            ->allowEmpty('metodo_mecanico_inicio');

        $validator
            ->date('metodo_mecanico_fim')
            ->allowEmpty('metodo_mecanico_fim');

        $validator
            ->allowEmpty('justificativa');

        $validator
            ->boolean('deambulacao')
            ->allowEmpty('deambulacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
