<?php
namespace App\Model\Table;

use App\Model\Entity\Contraindication;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contraindications Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $SurgicalTevProtocols
 */
class ContraindicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('contraindications');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('SurgicalTevProtocols', [
            'foreignKey' => 'contraindication_id',
            'targetForeignKey' => 'surgical_tev_protocol_id',
            'joinTable' => 'surgical_tev_protocols_contraindications'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        return $validator;
    }
}
