<?php
namespace App\Model\Table;

use App\Model\Entity\NeonatalChecklist;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * NeonatalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NeonatalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('neonatal_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('paridade')
            ->allowEmpty('paridade');

        $validator
            ->boolean('enfermidades_atuais')
            ->allowEmpty('enfermidades_atuais');

        $validator
            ->boolean('intercorren_pre_parto')
            ->allowEmpty('intercorren_pre_parto');

        $validator
            ->boolean('boletim_apgar')
            ->allowEmpty('boletim_apgar');

        $validator
            ->boolean('necessidade_reanimacao')
            ->allowEmpty('necessidade_reanimacao');

        $validator
            ->boolean('apto_amamentacao')
            ->allowEmpty('apto_amamentacao');

        $validator
            ->allowEmpty('placenta_peso');

        $validator
            ->boolean('coloracao_odor_alterado')
            ->allowEmpty('coloracao_odor_alterado');

        $validator
            ->boolean('relacao_do_peso_placenta')
            ->allowEmpty('relacao_do_peso_placenta');

        $validator
            ->boolean('cordao_umbilical_presente')
            ->allowEmpty('cordao_umbilical_presente');

        $validator
            ->allowEmpty('ao_nascer_peso');

        $validator
            ->allowEmpty('ao_nascer_comprimento');

        $validator
            ->boolean('ao_nascer_classificacao_rn')
            ->allowEmpty('ao_nascer_classificacao_rn');

        $validator
            ->boolean('iluminacao_aquecimento_adequado')
            ->allowEmpty('iluminacao_aquecimento_adequado');

        $validator
            ->boolean('ictericia')
            ->allowEmpty('ictericia');

        $validator
            ->boolean('palidez')
            ->allowEmpty('palidez');

        $validator
            ->boolean('descamacao_fisiologica')
            ->allowEmpty('descamacao_fisiologica');

        $validator
            ->boolean('icitose_congenita')
            ->allowEmpty('icitose_congenita');

        $validator
            ->boolean('nevos_pgmentosus')
            ->allowEmpty('nevos_pgmentosus');

        $validator
            ->boolean('linfomas_cisticos')
            ->allowEmpty('linfomas_cisticos');

        $validator
            ->boolean('escleredema')
            ->allowEmpty('escleredema');

        $validator
            ->boolean('petequias_e_purpuras')
            ->allowEmpty('petequias_e_purpuras');

        $validator
            ->boolean('hemangioma')
            ->allowEmpty('hemangioma');

        $validator
            ->boolean('pele_espessa')
            ->allowEmpty('pele_espessa');

        $validator
            ->boolean('visibilidade_vasos_sulcos')
            ->allowEmpty('visibilidade_vasos_sulcos');

        $validator
            ->boolean('lanugem')
            ->allowEmpty('lanugem');

        $validator
            ->boolean('superficie_plantar')
            ->allowEmpty('superficie_plantar');

        $validator
            ->numeric('distancia_antero_posterior')
            ->allowEmpty('distancia_antero_posterior');

        $validator
            ->numeric('distancia_biauricular')
            ->allowEmpty('distancia_biauricular');

        $validator
            ->allowEmpty('perimetro_cefalico');

        $validator
            ->numeric('indice_cefalico')
            ->allowEmpty('indice_cefalico');

        $validator
            ->allowEmpty('cranio_classificacao');

        $validator
            ->boolean('hidrocefalia')
            ->allowEmpty('hidrocefalia');

        $validator
            ->boolean('craniossinostose')
            ->allowEmpty('craniossinostose');

        $validator
            ->boolean('cefalo_hematoma')
            ->allowEmpty('cefalo_hematoma');

        $validator
            ->boolean('bossa_serossanguinea')
            ->allowEmpty('bossa_serossanguinea');

        $validator
            ->boolean('fontanelas_adequadas')
            ->allowEmpty('fontanelas_adequadas');

        $validator
            ->boolean('cranio_tabes')
            ->allowEmpty('cranio_tabes');

        $validator
            ->boolean('ruidos_intracranianos')
            ->allowEmpty('ruidos_intracranianos');

        $validator
            ->boolean('encefalocele')
            ->allowEmpty('encefalocele');

        $validator
            ->boolean('cartilagem_da_orelha')
            ->allowEmpty('cartilagem_da_orelha');

        $validator
            ->boolean('face_simetria')
            ->allowEmpty('face_simetria');

        $validator
            ->boolean('aparencia_sindromica')
            ->allowEmpty('aparencia_sindromica');

        $validator
            ->boolean('implantacao_das_orelhas')
            ->allowEmpty('implantacao_das_orelhas');

        $validator
            ->allowEmpty('distancia_entre_os_olhos');

        $validator
            ->boolean('tamanho_do_queixo')
            ->allowEmpty('tamanho_do_queixo');

        $validator
            ->boolean('reflexo_luz_vermelha')
            ->allowEmpty('reflexo_luz_vermelha');

        $validator
            ->boolean('hemorragia_subconjuntival')
            ->allowEmpty('hemorragia_subconjuntival');

        $validator
            ->boolean('estrabismo')
            ->allowEmpty('estrabismo');

        $validator
            ->boolean('pupila_branca')
            ->allowEmpty('pupila_branca');

        $validator
            ->boolean('opacificacao_cornea')
            ->allowEmpty('opacificacao_cornea');

        $validator
            ->boolean('secrecao_ocular_presente')
            ->allowEmpty('secrecao_ocular_presente');

        $validator
            ->boolean('forma_tamanho_implantacao')
            ->allowEmpty('forma_tamanho_implantacao');

        $validator
            ->boolean('permeabilidade_nasal')
            ->allowEmpty('permeabilidade_nasal');

        $validator
            ->boolean('canal_nasolacrimal')
            ->allowEmpty('canal_nasolacrimal');

        $validator
            ->boolean('secrecao_nasal')
            ->allowEmpty('secrecao_nasal');

        $validator
            ->boolean('coloracao_dos_labios')
            ->allowEmpty('coloracao_dos_labios');

        $validator
            ->boolean('alteracao_integridade')
            ->allowEmpty('alteracao_integridade');

        $validator
            ->boolean('fenda_palatina')
            ->allowEmpty('fenda_palatina');

        $validator
            ->boolean('lingua_com_tamanho')
            ->allowEmpty('lingua_com_tamanho');

        $validator
            ->boolean('dentes_congenitos')
            ->allowEmpty('dentes_congenitos');

        $validator
            ->boolean('ranula')
            ->allowEmpty('ranula');

        $validator
            ->boolean('perolas_de_epstein')
            ->allowEmpty('perolas_de_epstein');

        $validator
            ->boolean('uvula_bifida')
            ->allowEmpty('uvula_bifida');

        $validator
            ->boolean('retrognatia')
            ->allowEmpty('retrognatia');

        $validator
            ->boolean('arqueamento_do_palato')
            ->allowEmpty('arqueamento_do_palato');

        $validator
            ->boolean('ausencia_de_massas')
            ->allowEmpty('ausencia_de_massas');

        $validator
            ->boolean('torcicolo_congenito')
            ->allowEmpty('torcicolo_congenito');

        $validator
            ->boolean('teratoma_cervical')
            ->allowEmpty('teratoma_cervical');

        $validator
            ->boolean('higroma_cistico')
            ->allowEmpty('higroma_cistico');

        $validator
            ->boolean('bocio_congenito')
            ->allowEmpty('bocio_congenito');

        $validator
            ->allowEmpty('perimetro_toracico');

        $validator
            ->boolean('torax_simetria')
            ->allowEmpty('torax_simetria');

        $validator
            ->boolean('retracoes_sub_intercostais')
            ->allowEmpty('retracoes_sub_intercostais');

        $validator
            ->boolean('retracoes_supra_claviculares')
            ->allowEmpty('retracoes_supra_claviculares');

        $validator
            ->boolean('ausencia_claviculas')
            ->allowEmpty('ausencia_claviculas');

        $validator
            ->boolean('disostose_cleido')
            ->allowEmpty('disostose_cleido');

        $validator
            ->boolean('fraturas')
            ->allowEmpty('fraturas');

        $validator
            ->boolean('assimetria')
            ->allowEmpty('assimetria');

        $validator
            ->boolean('distancia_intermamilar')
            ->allowEmpty('distancia_intermamilar');

        $validator
            ->boolean('presencao_de_mamilos')
            ->allowEmpty('presencao_de_mamilos');

        $validator
            ->allowEmpty('inspecao');

        $validator
            ->boolean('pulsos_sincronia')
            ->allowEmpty('pulsos_sincronia');

        $validator
            ->boolean('pulsos_equivalentes')
            ->allowEmpty('pulsos_equivalentes');

        $validator
            ->boolean('palpacao_precordio')
            ->allowEmpty('palpacao_precordio');

        $validator
            ->allowEmpty('pressao_pulsatil');

        $validator
            ->boolean('desdobramento_de_b1')
            ->allowEmpty('desdobramento_de_b1');

        $validator
            ->boolean('reducao_intensidade')
            ->allowEmpty('reducao_intensidade');

        $validator
            ->boolean('aumento_intensidade_b1')
            ->allowEmpty('aumento_intensidade_b1');

        $validator
            ->boolean('desdobramento_amplo_b2')
            ->allowEmpty('desdobramento_amplo_b2');

        $validator
            ->boolean('hiperfonese_b2')
            ->allowEmpty('hiperfonese_b2');

        $validator
            ->boolean('presenca_de_b3')
            ->allowEmpty('presenca_de_b3');

        $validator
            ->boolean('presenca_de_b4')
            ->allowEmpty('presenca_de_b4');

        $validator
            ->boolean('presenca_de_estalido_abertura')
            ->allowEmpty('presenca_de_estalido_abertura');

        $validator
            ->boolean('presenca_de_sopro')
            ->allowEmpty('presenca_de_sopro');

        $validator
            ->allowEmpty('gemencia');

        $validator
            ->allowEmpty('batimento_de_asa_nariz');

        $validator
            ->allowEmpty('tiragem_intercostal');

        $validator
            ->allowEmpty('retracao_esternal');

        $validator
            ->allowEmpty('balancim');

        $validator
            ->boolean('sinal_dancarina_ventre')
            ->allowEmpty('sinal_dancarina_ventre');

        $validator
            ->boolean('presenca_cripitacao_pulmonar')
            ->allowEmpty('presenca_cripitacao_pulmonar');

        $validator
            ->boolean('presenca_de_roncos')
            ->allowEmpty('presenca_de_roncos');

        $validator
            ->boolean('diminuicao_murmurio_vesicular')
            ->allowEmpty('diminuicao_murmurio_vesicular');

        $validator
            ->boolean('abdome_escavado')
            ->allowEmpty('abdome_escavado');

        $validator
            ->boolean('abdome_abaulado')
            ->allowEmpty('abdome_abaulado');

        $validator
            ->boolean('abdomen_abaulamento')
            ->allowEmpty('abdomen_abaulamento');

        $validator
            ->boolean('presenca_circulacao_colateral')
            ->allowEmpty('presenca_circulacao_colateral');

        $validator
            ->boolean('presenca_ondas_peristalticas')
            ->allowEmpty('presenca_ondas_peristalticas');

        $validator
            ->boolean('dastase_musculos_reto')
            ->allowEmpty('dastase_musculos_reto');

        $validator
            ->boolean('ascite')
            ->allowEmpty('ascite');

        $validator
            ->boolean('visceromegalias')
            ->allowEmpty('visceromegalias');

        $validator
            ->boolean('distencao_gasosa')
            ->allowEmpty('distencao_gasosa');

        $validator
            ->boolean('presenca_de_massa_palpavel')
            ->allowEmpty('presenca_de_massa_palpavel');

        $validator
            ->boolean('ausencia_de_ruidos')
            ->allowEmpty('ausencia_de_ruidos');

        $validator
            ->boolean('genitalia_ambigua')
            ->allowEmpty('genitalia_ambigua');

        $validator
            ->allowEmpty('anomalias_anonetai');

        $validator
            ->boolean('comprimento_do_penis_adequado')
            ->allowEmpty('comprimento_do_penis_adequado');

        $validator
            ->allowEmpty('orificio_uretral');

        $validator
            ->boolean('prepucio_sem_restricao')
            ->allowEmpty('prepucio_sem_restricao');

        $validator
            ->allowEmpty('testiculos');

        $validator
            ->boolean('presenca_de_hemias')
            ->allowEmpty('presenca_de_hemias');

        $validator
            ->boolean('presenca_de_hidroceles')
            ->allowEmpty('presenca_de_hidroceles');

        $validator
            ->boolean('tamanho_do_clitoris_adequado')
            ->allowEmpty('tamanho_do_clitoris_adequado');

        $validator
            ->boolean('fusao_dos_grandes_labios')
            ->allowEmpty('fusao_dos_grandes_labios');

        $validator
            ->boolean('orificio_da_vagina_e_uretra')
            ->allowEmpty('orificio_da_vagina_e_uretra');

        $validator
            ->boolean('distancia_anovulvar')
            ->allowEmpty('distancia_anovulvar');

        $validator
            ->boolean('presenca_de_fistulas')
            ->allowEmpty('presenca_de_fistulas');

        $validator
            ->boolean('presenca_de_tumores')
            ->allowEmpty('presenca_de_tumores');

        $validator
            ->boolean('fossetas_hipertricose')
            ->allowEmpty('fossetas_hipertricose');

        $validator
            ->boolean('seio_pilonidal')
            ->allowEmpty('seio_pilonidal');

        $validator
            ->boolean('meningomielocele')
            ->allowEmpty('meningomielocele');

        $validator
            ->boolean('teratoma_sacroroccigeo')
            ->allowEmpty('teratoma_sacroroccigeo');

        $validator
            ->boolean('simetira_proprocoes')
            ->allowEmpty('simetira_proprocoes');

        $validator
            ->boolean('paralisia_membros_superiores')
            ->allowEmpty('paralisia_membros_superiores');

        $validator
            ->boolean('paralisia_membros_inferiores')
            ->allowEmpty('paralisia_membros_inferiores');

        $validator
            ->boolean('artogripose')
            ->allowEmpty('artogripose');

        $validator
            ->boolean('pe_torto_congenito')
            ->allowEmpty('pe_torto_congenito');

        $validator
            ->boolean('prega_palmar_unica')
            ->allowEmpty('prega_palmar_unica');

        $validator
            ->boolean('osteocondrodisplasia')
            ->allowEmpty('osteocondrodisplasia');

        $validator
            ->boolean('luxacao_congenita')
            ->allowEmpty('luxacao_congenita');

        $validator
            ->boolean('manobra_ortolani')
            ->allowEmpty('manobra_ortolani');

        $validator
            ->boolean('manobra_barlow')
            ->allowEmpty('manobra_barlow');

        $validator
            ->boolean('urina_nas_primeiras')
            ->allowEmpty('urina_nas_primeiras');

        $validator
            ->boolean('ausencia_eleminacao_intestinal')
            ->allowEmpty('ausencia_eleminacao_intestinal');

        $validator
            ->allowEmpty('estado_de_sono');

        $validator
            ->boolean('postura_em_flexao')
            ->allowEmpty('postura_em_flexao');

        $validator
            ->boolean('movimentacao_espontanea')
            ->allowEmpty('movimentacao_espontanea');

        $validator
            ->boolean('emissao_de_sons')
            ->allowEmpty('emissao_de_sons');

        $validator
            ->boolean('tonus_passivo_e_ativo')
            ->allowEmpty('tonus_passivo_e_ativo');

        $validator
            ->boolean('manobra_do_arrasto')
            ->allowEmpty('manobra_do_arrasto');

        $validator
            ->boolean('rotacao_da_cabeca_em_prono')
            ->allowEmpty('rotacao_da_cabeca_em_prono');

        $validator
            ->boolean('manobra_de_tobler')
            ->allowEmpty('manobra_de_tobler');

        $validator
            ->boolean('manobra_do_cachecol')
            ->allowEmpty('manobra_do_cachecol');

        $validator
            ->boolean('reflexos_superficiais')
            ->allowEmpty('reflexos_superficiais');

        $validator
            ->boolean('reflexos_arcaicos')
            ->allowEmpty('reflexos_arcaicos');

        $validator
            ->boolean('teste_de_voracidade')
            ->allowEmpty('teste_de_voracidade');

        $validator
            ->boolean('teste_de_succao')
            ->allowEmpty('teste_de_succao');

        $validator
            ->boolean('preensao_reflexa_artelhos')
            ->allowEmpty('preensao_reflexa_artelhos');

        $validator
            ->boolean('piscamento')
            ->allowEmpty('piscamento');

        $validator
            ->boolean('retirada_a_estimulacao')
            ->allowEmpty('retirada_a_estimulacao');

        $validator
            ->boolean('cutaneo_plantar')
            ->allowEmpty('cutaneo_plantar');

        $validator
            ->boolean('extensao_cruzada')
            ->allowEmpty('extensao_cruzada');

        $validator
            ->boolean('preensao_palmar')
            ->allowEmpty('preensao_palmar');

        $validator
            ->boolean('manobra_do_rasto')
            ->allowEmpty('manobra_do_rasto');

        $validator
            ->boolean('reflexo_de_moro')
            ->allowEmpty('reflexo_de_moro');

        $validator
            ->boolean('reflexo_tonico_cervical_assimetrico')
            ->allowEmpty('reflexo_tonico_cervical_assimetrico');

        $validator
            ->boolean('apoio_plantar')
            ->allowEmpty('apoio_plantar');

        $validator
            ->boolean('marcha_reflexa')
            ->allowEmpty('marcha_reflexa');

        $validator
            ->boolean('rotacao_da_cabeca')
            ->allowEmpty('rotacao_da_cabeca');

        $validator
            ->boolean('reflexo_de_galant')
            ->allowEmpty('reflexo_de_galant');

        $validator
            ->boolean('reflexos_de_landau')
            ->allowEmpty('reflexos_de_landau');

        $validator
            ->boolean('teste_do_nervo_optico')
            ->allowEmpty('teste_do_nervo_optico');

        $validator
            ->boolean('teste_dos_olhos_de_boneca')
            ->allowEmpty('teste_dos_olhos_de_boneca');

        $validator
            ->boolean('reflexo_vestibulo_coclear')
            ->allowEmpty('reflexo_vestibulo_coclear');

        $validator
            ->boolean('reflexo_cocleo_palpebral')
            ->allowEmpty('reflexo_cocleo_palpebral');

        $validator
            ->boolean('reflexos_miotaticos')
            ->allowEmpty('reflexos_miotaticos');

        $validator
            ->boolean('teste_de_sensibilidade')
            ->allowEmpty('teste_de_sensibilidade');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
