<?php
namespace App\Model\Table;

use App\Model\Entity\PavPreventionBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PavPreventionBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 */
class PavPreventionBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pav_prevention_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType'   => 'INNER',
        ]);

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType'   => 'INNER',
        ]);

        $this->hasMany('PavDiaryChecklists', [
            'foreignKey' => 'pav_prevention_bundle_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        // ->date('data_da_instalacao')
        ->requirePresence('data_da_instalacao', 'create')
            ->notEmpty('data_da_instalacao');

        $validator
        // ->time('hora_da_instalacao')
        ->requirePresence('hora_da_instalacao', 'create')
            ->notEmpty('hora_da_instalacao');

        $validator
            ->requirePresence('tipo_de_dispositivo', 'create')
            ->notEmpty('tipo_de_dispositivo');

        $validator
            ->allowEmpty('tamanho_do_tot');

        $validator
            ->allowEmpty('mascara_laringea');

        $validator
            ->allowEmpty('traqueostomia');

        $validator
            ->boolean('verificado_o_risco_de_vad')
            ->allowEmpty('verificado_o_risco_de_vad');

        $validator
            ->boolean('tci_foi_preenchido')
            ->allowEmpty('tci_foi_preenchido');

        $validator
            ->boolean('procedimento_a_ser_realizado_foi_prescrito')
            ->allowEmpty('procedimento_a_ser_realizado_foi_prescrito');

        $validator
            ->allowEmpty('observacao');

        $validator
            ->boolean('higienizacao_adequada_das_maos')
            ->allowEmpty('higienizacao_adequada_das_maos');

        $validator
            ->boolean('uso_de_paramentacao_gorro')
            ->allowEmpty('uso_de_paramentacao_gorro');

        $validator
            ->boolean('esvaziamento_gastrico')
            ->allowEmpty('esvaziamento_gastrico');

        $validator
            ->boolean('uso_de_degermacao')
            ->allowEmpty('uso_de_degermacao');

        $validator
            ->boolean('uso_de_vni_previo_a_intubacao')
            ->allowEmpty('uso_de_vni_previo_a_intubacao');

        $validator
            ->boolean('pococionamento_adequado_do_paciente')
            ->allowEmpty('pococionamento_adequado_do_paciente');

        $validator
            ->boolean('uso_de_laringoscpio')
            ->allowEmpty('uso_de_laringoscpio');

        $validator
            ->boolean('utilizacao_de_bnm')
            ->allowEmpty('utilizacao_de_bnm');

        $validator
            ->boolean('intubacao_esofageana')
            ->allowEmpty('intubacao_esofageana');

        $validator
            ->allowEmpty('durante_procedimento_observacao');

        $validator
            ->allowEmpty('local_de_insercao');

        $validator
            ->boolean('intubacao_unica')
            ->allowEmpty('intubacao_unica');

        $validator
            ->integer('numero_de_tentativas')
            ->allowEmpty('numero_de_tentativas');

        $validator
            ->allowEmpty('uso_do_kit_vad');

        $validator
            ->allowEmpty('sucesso_na_insercao');

        $validator
            ->allowEmpty('controle_radiologico');

        $validator
            ->integer('numero_de_profissionais')
            ->allowEmpty('numero_de_profissionais');

        $validator
            ->allowEmpty('outra_informacao');

        $validator
            ->allowEmpty('complicacoes_imediatas');

        $validator
        // ->date('data_da_retirada')
        ->allowEmpty('data_da_retirada');

        $validator
        // ->time('hora_da_retirada')
        ->allowEmpty('hora_da_retirada');

        $validator
            ->boolean('retirada_acidental')
            ->allowEmpty('retirada_acidental');

        $validator
            ->allowEmpty('motivo_da_retirada_acidental');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
