<?php
namespace App\Model\Table;

use App\Model\Entity\RelevantComplementaryExam;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * RelevantComplementaryExams Model
 *
 * @property \Cake\ORM\Association\BelongsTo $MedicalCares
 */
class RelevantComplementaryExamsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('relevant_complementary_exams');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('MedicalCares', [
            'foreignKey' => 'medical_care_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('htc');

        $validator
            ->allowEmpty('hb');

        $validator
            ->allowEmpty('leucocitos');

        $validator
            ->allowEmpty('bastoes');

        $validator
            ->allowEmpty('plaquetas');

        $validator
            ->allowEmpty('tap');

        $validator
            ->allowEmpty('ptt');

        $validator
            ->allowEmpty('pcr_t');

        $validator
            ->allowEmpty('d_dimero');

        $validator
            ->allowEmpty('bnp');

        $validator
            ->allowEmpty('lactato');

        $validator
            ->allowEmpty('glicemia');

        $validator
            ->allowEmpty('ureia');

        $validator
            ->allowEmpty('creatina');

        $validator
            ->allowEmpty('na');

        $validator
            ->allowEmpty('k');

        $validator
            ->allowEmpty('bd_bi');

        $validator
            ->allowEmpty('tgo_tgp');

        $validator
            ->allowEmpty('gama_gt');

        $validator
            ->allowEmpty('f_alcalina');

        $validator
            ->allowEmpty('amialise');

        $validator
            ->allowEmpty('lipase');

        $validator
            ->allowEmpty('tiropinina_1');

        $validator
            ->allowEmpty('tiropinina_2');

        $validator
            ->allowEmpty('ck_massa_1');

        $validator
            ->allowEmpty('ck_massa_2');

        $validator
            ->allowEmpty('ck_total_1');

        $validator
            ->allowEmpty('ck_total_2');

        $validator
            ->allowEmpty('ph');

        $validator
            ->allowEmpty('pco2');

        $validator
            ->allowEmpty('po2');

        $validator
            ->allowEmpty('hco3');

        $validator
            ->allowEmpty('be');

        $validator
            ->allowEmpty('sato2');

        $validator
            ->allowEmpty('nora');

        $validator
            ->allowEmpty('encrise');

        $validator
            ->allowEmpty('dobuta');

        $validator
            ->allowEmpty('dopamina');

        $validator
            ->allowEmpty('tridil');

        $validator
            ->allowEmpty('nipride');

        $validator
            ->allowEmpty('protofol');

        $validator
            ->allowEmpty('precedex');

        $validator
            ->allowEmpty('fentanil');

        $validator
            ->allowEmpty('dormonid');

        $validator
            ->allowEmpty('outros_exames_relevantes');

        $validator
            ->allowEmpty('rx_de_torax');

        $validator
            ->allowEmpty('impressao_diagnostica');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['medical_care_id'], 'MedicalCares'));
        return $rules;
    }
}
